/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.jdbc.internal.AtomikosJdbcStatementProxy;
import com.atomikos.jdbc.internal.AtomikosSQLException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.DynamicProxySupport;
import com.atomikos.util.Proxied;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractJdbcConnectionProxy
extends DynamicProxySupport<Connection> {
    private static final Logger LOGGER = LoggerFactory.createLogger(AbstractJdbcConnectionProxy.class);
    private List<Statement> statements = new ArrayList<Statement>();

    public AbstractJdbcConnectionProxy(Connection delegate) {
        super((Object)delegate);
    }

    protected synchronized void addStatement(Statement s) {
        this.statements.add(s);
    }

    protected synchronized void removeStatement(Statement s) {
        this.statements.remove(s);
    }

    protected abstract void updateTransactionContext() throws SQLException;

    protected abstract boolean isEnlistedInGlobalTransaction();

    @Proxied
    public Statement createStatement() throws SQLException {
        this.updateTransactionContext();
        Statement s = ((Connection)this.delegate).createStatement();
        return this.createProxyStatement(s);
    }

    private <S extends Statement> S createProxyStatement(S s) {
        AtomikosJdbcStatementProxy<S> ajsp = new AtomikosJdbcStatementProxy<S>(this, s);
        Statement proxy = (Statement)ajsp.createDynamicProxy();
        this.addStatement(s);
        return (S)proxy;
    }

    @Proxied
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.updateTransactionContext();
        PreparedStatement s = ((Connection)this.delegate).prepareStatement(sql);
        return this.createProxyStatement(s);
    }

    @Proxied
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.updateTransactionContext();
        CallableStatement s = ((Connection)this.delegate).prepareCall(sql);
        return this.createProxyStatement(s);
    }

    @Proxied
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.updateTransactionContext();
        Statement s = ((Connection)this.delegate).createStatement(resultSetType, resultSetConcurrency);
        return this.createProxyStatement(s);
    }

    @Proxied
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.updateTransactionContext();
        PreparedStatement s = ((Connection)this.delegate).prepareStatement(sql, resultSetType, resultSetConcurrency);
        return this.createProxyStatement(s);
    }

    @Proxied
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.updateTransactionContext();
        CallableStatement s = ((Connection)this.delegate).prepareCall(sql, resultSetType, resultSetConcurrency);
        return this.createProxyStatement(s);
    }

    @Proxied
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.updateTransactionContext();
        Statement s = ((Connection)this.delegate).createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createProxyStatement(s);
    }

    @Proxied
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.updateTransactionContext();
        PreparedStatement s = ((Connection)this.delegate).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createProxyStatement(s);
    }

    @Proxied
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.updateTransactionContext();
        CallableStatement s = ((Connection)this.delegate).prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.createProxyStatement(s);
    }

    @Proxied
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.updateTransactionContext();
        PreparedStatement s = ((Connection)this.delegate).prepareStatement(sql, autoGeneratedKeys);
        return this.createProxyStatement(s);
    }

    @Proxied
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.updateTransactionContext();
        PreparedStatement s = ((Connection)this.delegate).prepareStatement(sql, columnIndexes);
        return this.createProxyStatement(s);
    }

    @Proxied
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.updateTransactionContext();
        PreparedStatement s = ((Connection)this.delegate).prepareStatement(sql, columnNames);
        return this.createProxyStatement(s);
    }

    @Proxied
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isEnlistedInGlobalTransaction()) {
            if (autoCommit) {
                AtomikosSQLException.throwAtomikosSQLException("Cannot call 'setAutoCommit(true)' while a global transaction is running");
            }
        } else {
            ((Connection)this.delegate).setAutoCommit(autoCommit);
        }
    }

    @Proxied
    public boolean getAutoCommit() throws SQLException {
        if (this.isEnlistedInGlobalTransaction()) {
            return false;
        }
        return ((Connection)this.delegate).getAutoCommit();
    }

    @Proxied
    public void commit() throws SQLException {
        if (this.isEnlistedInGlobalTransaction()) {
            AtomikosSQLException.throwAtomikosSQLException("Cannot call method 'commit' while a global transaction is running");
        }
        ((Connection)this.delegate).commit();
    }

    @Proxied
    public void rollback() throws SQLException {
        if (this.isEnlistedInGlobalTransaction()) {
            AtomikosSQLException.throwAtomikosSQLException("Cannot call method 'rollback' while a global transaction is running");
        }
        ((Connection)this.delegate).rollback();
    }

    @Proxied
    public Savepoint setSavepoint() throws SQLException {
        if (this.isEnlistedInGlobalTransaction()) {
            AtomikosSQLException.throwAtomikosSQLException("Cannot call method 'setSavepoint()' while a global transaction is running");
        }
        return ((Connection)this.delegate).setSavepoint();
    }

    @Proxied
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.isEnlistedInGlobalTransaction()) {
            AtomikosSQLException.throwAtomikosSQLException("Cannot call method 'setSavepoint(name)' while a global transaction is running");
        }
        return ((Connection)this.delegate).setSavepoint(name);
    }

    @Proxied
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.isEnlistedInGlobalTransaction()) {
            AtomikosSQLException.throwAtomikosSQLException("Cannot call method 'rollback(Savepoint)' while a global transaction is running");
        }
        ((Connection)this.delegate).rollback(savepoint);
    }

    @Proxied
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.isEnlistedInGlobalTransaction()) {
            AtomikosSQLException.throwAtomikosSQLException("Cannot call method 'releaseSavepoint(savepoint)' while a global transaction is running");
        }
        ((Connection)this.delegate).releaseSavepoint(savepoint);
    }

    @Proxied
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    protected void throwInvocationAfterClose(String methodName) throws AtomikosSQLException {
        String msg = "Connection was already closed - calling " + methodName + " is no longer allowed!";
        AtomikosSQLException.throwAtomikosSQLException(msg);
    }

    protected synchronized void forceCloseAllPendingStatements(boolean warn) {
        Iterator<Statement> it = this.statements.iterator();
        while (it.hasNext()) {
            Statement s = it.next();
            try {
                String msg = "Forcing close of pending statement: " + s;
                if (warn) {
                    LOGGER.logWarning(msg);
                } else {
                    LOGGER.logTrace(msg);
                }
                s.close();
            }
            catch (Exception e) {
                LOGGER.logWarning("Error closing pending statement: ", (Throwable)e);
            }
            it.remove();
        }
    }
}

