/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeletableItem;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class BatchDeleteAttributesRequestMarshaller
implements Marshaller<Request<BatchDeleteAttributesRequest>, BatchDeleteAttributesRequest> {
    public Request<BatchDeleteAttributesRequest> marshall(BatchDeleteAttributesRequest batchDeleteAttributesRequest) {
        SdkInternalList itemsList;
        if (batchDeleteAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchDeleteAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "BatchDeleteAttributes");
        request.addParameter("Version", "2009-04-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (batchDeleteAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)batchDeleteAttributesRequest.getDomainName()));
        }
        if (!(itemsList = (SdkInternalList)batchDeleteAttributesRequest.getItems()).isEmpty() || !itemsList.isAutoConstruct()) {
            int itemsListIndex = 1;
            for (DeletableItem itemsListValue : itemsList) {
                SdkInternalList attributesList;
                if (itemsListValue.getName() != null) {
                    request.addParameter("Item." + itemsListIndex + ".ItemName", StringUtils.fromString((String)itemsListValue.getName()));
                }
                if (!(attributesList = (SdkInternalList)itemsListValue.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                    int attributesListIndex = 1;
                    for (Attribute attributesListValue : attributesList) {
                        if (attributesListValue.getName() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Name", StringUtils.fromString((String)attributesListValue.getName()));
                        }
                        if (attributesListValue.getAlternateNameEncoding() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".AlternateNameEncoding", StringUtils.fromString((String)attributesListValue.getAlternateNameEncoding()));
                        }
                        if (attributesListValue.getValue() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Value", StringUtils.fromString((String)attributesListValue.getValue()));
                        }
                        if (attributesListValue.getAlternateValueEncoding() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".AlternateValueEncoding", StringUtils.fromString((String)attributesListValue.getAlternateValueEncoding()));
                        }
                        ++attributesListIndex;
                    }
                }
                ++itemsListIndex;
            }
        }
        return request;
    }
}

