/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAnalysisSchemesRequestMarshaller
implements Marshaller<Request<DescribeAnalysisSchemesRequest>, DescribeAnalysisSchemesRequest> {
    public Request<DescribeAnalysisSchemesRequest> marshall(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        SdkInternalList analysisSchemeNamesList;
        if (describeAnalysisSchemesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAnalysisSchemesRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeAnalysisSchemes");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAnalysisSchemesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeAnalysisSchemesRequest.getDomainName()));
        }
        if (!(analysisSchemeNamesList = (SdkInternalList)describeAnalysisSchemesRequest.getAnalysisSchemeNames()).isEmpty() || !analysisSchemeNamesList.isAutoConstruct()) {
            int analysisSchemeNamesListIndex = 1;
            for (String analysisSchemeNamesListValue : analysisSchemeNamesList) {
                if (analysisSchemeNamesListValue != null) {
                    request.addParameter("AnalysisSchemeNames.member." + analysisSchemeNamesListIndex, StringUtils.fromString((String)analysisSchemeNamesListValue));
                }
                ++analysisSchemeNamesListIndex;
            }
        }
        if (describeAnalysisSchemesRequest.getDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeAnalysisSchemesRequest.getDeployed()));
        }
        return request;
    }
}

