/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationautoscaling.model.RegisterScalableTargetRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RegisterScalableTargetRequestMarshaller
implements Marshaller<Request<RegisterScalableTargetRequest>, RegisterScalableTargetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterScalableTargetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RegisterScalableTargetRequest> marshall(RegisterScalableTargetRequest registerScalableTargetRequest) {
        if (registerScalableTargetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerScalableTargetRequest, "AWSApplicationAutoScaling");
        request.addHeader("X-Amz-Target", "AnyScaleFrontendService.RegisterScalableTarget");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerScalableTargetRequest.getServiceNamespace() != null) {
                jsonGenerator.writeFieldName("ServiceNamespace").writeValue(registerScalableTargetRequest.getServiceNamespace());
            }
            if (registerScalableTargetRequest.getResourceId() != null) {
                jsonGenerator.writeFieldName("ResourceId").writeValue(registerScalableTargetRequest.getResourceId());
            }
            if (registerScalableTargetRequest.getScalableDimension() != null) {
                jsonGenerator.writeFieldName("ScalableDimension").writeValue(registerScalableTargetRequest.getScalableDimension());
            }
            if (registerScalableTargetRequest.getMinCapacity() != null) {
                jsonGenerator.writeFieldName("MinCapacity").writeValue(registerScalableTargetRequest.getMinCapacity().intValue());
            }
            if (registerScalableTargetRequest.getMaxCapacity() != null) {
                jsonGenerator.writeFieldName("MaxCapacity").writeValue(registerScalableTargetRequest.getMaxCapacity().intValue());
            }
            if (registerScalableTargetRequest.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(registerScalableTargetRequest.getRoleARN());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

