/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.ONSUnitUtils;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSConsumerAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.spi.DefaultInvocationContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.DefaultConsumerRetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.retry.RetryStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ConsumerImpl
extends ONSConsumerAbstract
implements Consumer {
    private final ConcurrentHashMap<String, MessageListener> subscribeTable = new ConcurrentHashMap();

    public ConsumerImpl(Properties properties) {
        this(properties, new DefaultConsumerRetryStrategy());
    }

    public ConsumerImpl(Properties properties, RetryStrategy retryStrategy) {
        super(properties, retryStrategy);
        boolean postSubscriptionWhenPull = Boolean.parseBoolean(properties.getProperty("PostSubscriptionWhenPull", "false"));
        this.defaultMQPushConsumer.setPostSubscriptionWhenPull(postSubscriptionWhenPull);
        String messageModel = properties.getProperty("MessageModel", "CLUSTERING");
        this.defaultMQPushConsumer.setMessageModel(MessageModel.valueOf(messageModel));
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new MessageListenerImpl());
        super.start();
    }

    @Override
    public void subscribe(String topic, String subExpression, MessageListener listener) {
        if (null == topic) {
            throw new ONSClientException("topic is null");
        }
        if (null == listener) {
            throw new ONSClientException("listener is null");
        }
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public void subscribe(String topic, MessageSelector selector, MessageListener listener) {
        if (null == topic) {
            throw new ONSClientException("topic is null");
        }
        if (null == listener) {
            throw new ONSClientException("listener is null");
        }
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, selector);
    }

    @Override
    public void unsubscribe(String topic) {
        if (null != topic) {
            this.subscribeTable.remove(topic);
            super.unsubscribe(topic);
        }
    }

    class MessageListenerImpl
    implements MessageListenerConcurrently {
        MessageListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgsRMQList, ConsumeConcurrentlyContext contextRMQ) {
            MessageExt msgRMQ = msgsRMQList.get(0);
            Message msg = ONSUtil.msgConvert(msgRMQ);
            Map<String, String> stringStringMap = msgRMQ.getProperties();
            msg.setMsgID(msgRMQ.getMsgId());
            MessageListener listener = (MessageListener)ConsumerImpl.this.subscribeTable.get(msg.getTopic());
            if (null == listener) {
                throw new ONSClientException("MessageListener is null");
            }
            ConsumeContext context = new ConsumeContext();
            DefaultInvocationContext invocationContext = new DefaultInvocationContext();
            invocationContext.setNamespaceId(ConsumerImpl.this.defaultMQPushConsumer.getNamespace());
            invocationContext.setConsumerGroup(NamespaceUtil.withoutNamespace(ConsumerImpl.this.defaultMQPushConsumer.getConsumerGroup()));
            invocationContext.setMessages(Collections.singletonList(msg));
            ArrayList<Runnable> postHandleStack = new ArrayList<Runnable>();
            boolean proceed = ConsumerImpl.this.preHandle(ConsumerImpl.this.interceptors, invocationContext, postHandleStack);
            if (StringUtils.isNotBlank(ONSUnitUtils.getMSHAUnitRetry(msg))) {
                MessageAccessor.putProperty(msgRMQ, "__RMQ.TRANSIENT.MSHA_RETRY", ONSUnitUtils.getMSHAUnitRetry(msg));
            }
            try {
                if (proceed) {
                    Action action = listener.consume(msg, context);
                    invocationContext.setAction(action);
                    if (action == null) {
                        ConsumeConcurrentlyStatus consumeConcurrentlyStatus = ConsumeConcurrentlyStatus.RECONSUME_LATER;
                        return consumeConcurrentlyStatus;
                    }
                    ConsumeConcurrentlyStatus consumeConcurrentlyStatus = ConsumerImpl.this.action2Status(action);
                    return consumeConcurrentlyStatus;
                }
                if (!invocationContext.getAction().isPresent()) {
                    ConsumeConcurrentlyStatus consumeConcurrentlyStatus = ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                    return consumeConcurrentlyStatus;
                }
                ConsumeConcurrentlyStatus consumeConcurrentlyStatus = ConsumerImpl.this.action2Status(invocationContext.getAction().get());
                return consumeConcurrentlyStatus;
            }
            finally {
                ConsumerImpl.this.executePostHandle(postHandleStack);
            }
        }
    }
}

