/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.batch.BatchConsumer;
import com.aliyun.openservices.ons.api.batch.BatchMessageListener;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSConsumerAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.spi.DefaultInvocationContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class BatchConsumerImpl
extends ONSConsumerAbstract
implements BatchConsumer {
    private static final int MAX_BATCH_SIZE = 1024;
    private static final int MIN_BATCH_SIZE = 1;
    private final ConcurrentHashMap<String, BatchMessageListener> subscribeTable = new ConcurrentHashMap();

    public BatchConsumerImpl(Properties properties) {
        super(properties);
        String timedBatchConsumeAwaitDuration;
        boolean postSubscriptionWhenPull = Boolean.parseBoolean(properties.getProperty("PostSubscriptionWhenPull", "false"));
        this.defaultMQPushConsumer.setPostSubscriptionWhenPull(postSubscriptionWhenPull);
        String messageModel = properties.getProperty("MessageModel", "CLUSTERING");
        this.defaultMQPushConsumer.setMessageModel(MessageModel.valueOf(messageModel));
        String consumeBatchSize = properties.getProperty("ConsumeMessageBatchMaxSize");
        if (!UtilAll.isBlank(consumeBatchSize)) {
            int batchSize = Math.min(1024, Integer.valueOf(consumeBatchSize));
            batchSize = Math.max(1, batchSize);
            this.defaultMQPushConsumer.setConsumeMessageBatchMaxSize(batchSize);
        }
        if (!UtilAll.isBlank(timedBatchConsumeAwaitDuration = properties.getProperty("batchConsumeMaxAwaitDurationInSeconds"))) {
            try {
                long duration = Long.parseLong(timedBatchConsumeAwaitDuration);
                this.defaultMQPushConsumer.setMaxBatchConsumeWaitTime(duration, TimeUnit.SECONDS);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Number format error", e);
            }
            catch (MQClientException e) {
                LOGGER.error("Invalid value for BatchConsumeMaxAwaitDurationInSeconds", e);
            }
        }
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new BatchMessageListenerImpl(this.subscribeTable));
        super.start();
    }

    @Override
    public void subscribe(String topic, String subExpression, BatchMessageListener listener) {
        if (null == topic) {
            throw new ONSClientException("topic is null");
        }
        if (null == listener) {
            throw new ONSClientException("listener is null");
        }
        this.subscribeTable.put(topic, listener);
        super.subscribe(topic, subExpression);
    }

    @Override
    public void unsubscribe(String topic) {
        if (null != topic) {
            this.subscribeTable.remove(topic);
            super.unsubscribe(topic);
        }
    }

    class BatchMessageListenerImpl
    implements MessageListenerConcurrently {
        private final ConcurrentMap<String, BatchMessageListener> subscribeTable;

        public BatchMessageListenerImpl(ConcurrentMap<String, BatchMessageListener> subscribeTable) {
            this.subscribeTable = subscribeTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> rmqMsgList, ConsumeConcurrentlyContext contextRMQ) {
            ArrayList<Message> msgList = new ArrayList<Message>();
            for (MessageExt rmqMsg : rmqMsgList) {
                Message msg = ONSUtil.msgConvert(rmqMsg);
                Map<String, String> propertiesMap = rmqMsg.getProperties();
                msg.setMsgID(rmqMsg.getMsgId());
                if (propertiesMap != null && propertiesMap.get("__transactionId__") != null) {
                    msg.setMsgID(propertiesMap.get("__transactionId__"));
                }
                msgList.add(msg);
            }
            BatchMessageListener listener = (BatchMessageListener)this.subscribeTable.get(((Message)msgList.get(0)).getTopic());
            if (null == listener) {
                throw new ONSClientException("BatchMessageListener is null");
            }
            ConsumeContext context = new ConsumeContext();
            DefaultInvocationContext invocationContext = new DefaultInvocationContext();
            invocationContext.setMessages(msgList);
            ArrayList<Runnable> postHandleStack = new ArrayList<Runnable>();
            boolean proceed = BatchConsumerImpl.this.preHandle(BatchConsumerImpl.this.serviceLoader, invocationContext, postHandleStack);
            try {
                Action action;
                if (proceed && (action = listener.consume(msgList, context)) != null) {
                    switch (action) {
                        case CommitMessage: {
                            ConsumeConcurrentlyStatus consumeConcurrentlyStatus = ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                            return consumeConcurrentlyStatus;
                        }
                        case ReconsumeLater: {
                            ConsumeConcurrentlyStatus consumeConcurrentlyStatus = ConsumeConcurrentlyStatus.RECONSUME_LATER;
                            return consumeConcurrentlyStatus;
                        }
                    }
                }
                ConsumeConcurrentlyStatus consumeConcurrentlyStatus = ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                return consumeConcurrentlyStatus;
            }
            finally {
                contextRMQ.setAckIndex(context.getAcknowledgeIndex());
                BatchConsumerImpl.this.executePostHandle(postHandleStack);
            }
        }
    }
}

