package com.aliyun.core.http;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class HttpResponse implements Closeable {
    private final HttpRequest request;

    protected HttpResponse(HttpRequest request) {
        this.request = request;
    }

    public abstract int getStatusCode();

    public abstract String getHeaderValue(String name);

    public abstract HttpHeaders getHeaders();

    public abstract ByteBuffer getBody();

    public abstract byte[] getBodyAsByteArray();

    public abstract String getBodyAsString();

    public abstract String getBodyAsString(Charset charset);

    public final HttpRequest getRequest() {
        return request;
    }

    public HttpResponse buffer() {
        return new BufferedHttpResponse(this);
    }

    @Override
    public void close() { }
}
