/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redis.lettuce;

import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redis.lettuce.LettuceBroadcastManager;
import com.alicp.jetcache.redis.lettuce.LettuceConnectionManager;
import com.alicp.jetcache.redis.lettuce.RedisLettuceCache;
import com.alicp.jetcache.redis.lettuce.RedisLettuceCacheConfig;
import com.alicp.jetcache.support.BroadcastManager;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;

public class RedisLettuceCacheBuilder<T extends ExternalCacheBuilder<T>>
extends ExternalCacheBuilder<T> {
    public static RedisLettuceCacheBuilderImpl createRedisLettuceCacheBuilder() {
        return new RedisLettuceCacheBuilderImpl();
    }

    protected RedisLettuceCacheBuilder() {
        this.buildFunc(config -> new RedisLettuceCache((RedisLettuceCacheConfig)((Object)config)));
    }

    public RedisLettuceCacheConfig getConfig() {
        if (this.config == null) {
            this.config = new RedisLettuceCacheConfig();
        }
        return (RedisLettuceCacheConfig)this.config;
    }

    public boolean supportBroadcast() {
        return true;
    }

    public BroadcastManager createBroadcastManager(CacheManager cacheManager) {
        RedisLettuceCacheConfig c = (RedisLettuceCacheConfig)this.getConfig().clone();
        return new LettuceBroadcastManager(cacheManager, c);
    }

    public T redisClient(AbstractRedisClient redisClient) {
        this.getConfig().setRedisClient(redisClient);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setRedisClient(AbstractRedisClient redisClient) {
        this.getConfig().setRedisClient(redisClient);
    }

    public T connection(StatefulConnection connection) {
        this.getConfig().setConnection((StatefulConnection<byte[], byte[]>)connection);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setConnection(StatefulConnection connection) {
        this.getConfig().setConnection((StatefulConnection<byte[], byte[]>)connection);
    }

    public T pubSubConnection(StatefulRedisPubSubConnection pubSubConnection) {
        this.getConfig().setPubSubConnection((StatefulRedisPubSubConnection<byte[], byte[]>)pubSubConnection);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setPubSubConnection(StatefulRedisPubSubConnection pubSubConnection) {
        this.getConfig().setPubSubConnection((StatefulRedisPubSubConnection<byte[], byte[]>)pubSubConnection);
    }

    public T connectionManager(LettuceConnectionManager connectionManager) {
        this.getConfig().setConnectionManager(connectionManager);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setConnectionManager(LettuceConnectionManager connectionManager) {
        this.getConfig().setConnectionManager(connectionManager);
    }

    public T asyncResultTimeoutInMillis(long asyncResultTimeoutInMillis) {
        this.getConfig().setAsyncResultTimeoutInMillis(asyncResultTimeoutInMillis);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setAsyncResultTimeoutInMillis(long asyncResultTimeoutInMillis) {
        this.getConfig().setAsyncResultTimeoutInMillis(asyncResultTimeoutInMillis);
    }

    public static class RedisLettuceCacheBuilderImpl
    extends RedisLettuceCacheBuilder<RedisLettuceCacheBuilderImpl> {
    }
}

