/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.util;

import com.alibaba.simpleimage.jai.cmm.CMMColorSpace;
import com.alibaba.simpleimage.util.JAIRegisterHelper;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;

public class ImageColorConvertHelper {
    public static PlanarImage convert2sRGB(PlanarImage src) {
        if (src.getColorModel() instanceof IndexColorModel) {
            src = ImageColorConvertHelper.convertIndexColorModel2RGB(src);
        }
        if (src.getColorModel().getColorSpace().getType() == 9) {
            src = ImageColorConvertHelper.convertCMYK2RGB(src);
        } else if (src.getColorModel().getColorSpace().getType() == 6) {
            src = ImageColorConvertHelper.convertGray2RGB(src);
        }
        if (!src.getColorModel().getColorSpace().isCS_sRGB() || src.getSampleModel().getDataType() != 0) {
            src = ImageColorConvertHelper.generalColorConvert(src);
        }
        return src;
    }

    public static PlanarImage generalColorConvert(PlanarImage src) {
        ColorSpace sRGBColorSpace = ColorSpace.getInstance(1000);
        ComponentColorModel sRGBColorModel = RasterFactory.createComponentColorModel((int)0, (ColorSpace)sRGBColorSpace, (boolean)false, (boolean)false, (int)1);
        ImageLayout rgbImageLayout = new ImageLayout();
        rgbImageLayout.setSampleModel(((ColorModel)sRGBColorModel).createCompatibleSampleModel(src.getWidth(), src.getHeight()));
        RenderingHints rgbHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, rgbImageLayout);
        rgbHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ParameterBlockJAI pb = new ParameterBlockJAI("colorconvert");
        pb.addSource((Object)src);
        pb.setParameter("colormodel", (Object)sRGBColorModel);
        return JAI.create((String)"colorconvert", (ParameterBlock)pb, (RenderingHints)rgbHints);
    }

    public static PlanarImage convertCMYK2RGB(PlanarImage src) {
        ColorSpace srcColorSpace = src.getColorModel().getColorSpace();
        if (srcColorSpace.getType() != 9) {
            return src;
        }
        if (srcColorSpace instanceof ICC_ColorSpace) {
            ColorSpace rgbColorSpace = ColorSpace.getInstance(1000);
            ComponentColorModel rgbColorModel = RasterFactory.createComponentColorModel((int)0, (ColorSpace)rgbColorSpace, (boolean)false, (boolean)true, (int)1);
            ImageLayout rgbImageLayout = new ImageLayout();
            rgbImageLayout.setSampleModel(((ColorModel)rgbColorModel).createCompatibleSampleModel(src.getWidth(), src.getHeight()));
            RenderingHints rgbHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, rgbImageLayout);
            rgbHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ParameterBlockJAI pb = new ParameterBlockJAI("colorconvert");
            pb.addSource((Object)src);
            pb.setParameter("colormodel", (Object)rgbColorModel);
            return JAI.create((String)"colorconvert", (ParameterBlock)pb, (RenderingHints)rgbHints);
        }
        ColorSpace cmykColorSpace = CMMColorSpace.getInstance(src.getColorModel().getColorSpace().getType());
        ComponentColorModel cmykColorModel = RasterFactory.createComponentColorModel((int)src.getSampleModel().getDataType(), (ColorSpace)cmykColorSpace, (boolean)false, (boolean)true, (int)1);
        ImageLayout cmykImageLayout = new ImageLayout();
        cmykImageLayout.setColorModel((ColorModel)cmykColorModel);
        RenderingHints cmykHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, cmykImageLayout);
        cmykHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ParameterBlockJAI pb = new ParameterBlockJAI("format");
        pb.addSource((Object)src);
        pb.setParameter("datatype", src.getSampleModel().getDataType());
        RenderedOp op = JAI.create((String)"format", (ParameterBlock)pb, (RenderingHints)cmykHints);
        pb = new ParameterBlockJAI("invert");
        pb.addSource((Object)src);
        op = JAI.create((String)"invert", (ParameterBlock)pb, (RenderingHints)cmykHints);
        ColorSpace rgbColorSpace = ColorSpace.getInstance(1000);
        ComponentColorModel rgbColorModel = RasterFactory.createComponentColorModel((int)0, (ColorSpace)rgbColorSpace, (boolean)false, (boolean)true, (int)1);
        ImageLayout rgbImageLayout = new ImageLayout();
        rgbImageLayout.setSampleModel(((ColorModel)rgbColorModel).createCompatibleSampleModel(op.getWidth(), op.getHeight()));
        RenderingHints rgbHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, rgbImageLayout);
        rgbHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        pb = new ParameterBlockJAI("colorconvert");
        pb.addSource((Object)op);
        pb.setParameter("colormodel", (Object)rgbColorModel);
        return JAI.create((String)"colorconvert", (ParameterBlock)pb, (RenderingHints)rgbHints);
    }

    public static PlanarImage convertIndexColorModel2RGB(PlanarImage src) {
        ColorModel cm = src.getColorModel();
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)src.getColorModel();
            int newNumBands = icm.getNumComponents();
            if (newNumBands < 3) {
                throw new IllegalArgumentException("The number of Components of this image is less than 3");
            }
            int mapSize = icm.getMapSize();
            byte[][] lutData = new byte[newNumBands][mapSize];
            icm.getReds(lutData[0]);
            icm.getGreens(lutData[1]);
            icm.getBlues(lutData[2]);
            if (newNumBands == 4) {
                icm.getAlphas(lutData[3]);
            }
            LookupTableJAI lut = new LookupTableJAI(lutData);
            src = JAI.create((String)"lookup", (RenderedImage)src, (Object)lut);
        }
        return src;
    }

    public static PlanarImage convertRGBA2RGB(PlanarImage src) {
        ColorModel cm = src.getColorModel();
        if (cm.getColorSpace().getType() == 5 && src.getNumBands() == 4) {
            if (!cm.getColorSpace().isCS_sRGB()) {
                src = ImageColorConvertHelper.generalColorConvert(src);
            }
            ParameterBlock pb = new ParameterBlock();
            int[] bitsRGB = new int[]{8, 8, 8};
            ColorSpace sRGB = ColorSpace.getInstance(1000);
            ComponentColorModel cmRGB = new ComponentColorModel(sRGB, bitsRGB, false, false, 1, 0);
            ImageLayout il = new ImageLayout();
            il.setColorModel((ColorModel)cmRGB);
            RenderingHints rh = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il);
            il.setSampleModel(((ColorModel)cmRGB).createCompatibleSampleModel(src.getTileWidth(), src.getTileHeight()));
            pb = new ParameterBlock();
            pb.addSource(src);
            src = JAI.create((String)"format", (ParameterBlock)pb, (RenderingHints)rh);
        }
        return src;
    }

    public static PlanarImage convertGray2RGB(PlanarImage src) {
        ColorSpace srcCS = src.getColorModel().getColorSpace();
        if (srcCS.getType() == 6) {
            int x = 3;
            int y = src.getSampleModel().getNumBands() + 1;
            double[][] matrix = new double[x][y];
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    matrix[i][j] = j == 0 ? 1.0 : 0.0;
                }
            }
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(src);
            pb.add(matrix);
            src = JAI.create((String)"bandcombine", (ParameterBlock)pb, null);
        }
        return src;
    }

    static {
        JAIRegisterHelper.register();
    }
}

