/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import com.alibaba.simpleimage.font.FontManager;
import com.alibaba.simpleimage.render.DrawTextItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import org.apache.commons.lang.StringUtils;

public class FixDrawTextItem
extends DrawTextItem {
    static final Color FONT_COLOR = new Color(255, 255, 255, 115);
    static final Color FONT_SHADOW_COLOR = new Color(170, 170, 170, 77);
    static final Font FONT = FontManager.getFont("\u65b9\u6b63\u9ed1\u4f53");
    static final float DEFAULT_TEXT_WIDTH_PERCENT = 0.85f;
    protected float textWidthPercent;
    protected Position position;

    public FixDrawTextItem(String text) {
        super(text, FONT_COLOR, FONT_SHADOW_COLOR, FONT, 10);
        this.position = Position.CENTER;
        this.textWidthPercent = 0.85f;
    }

    public FixDrawTextItem(String text, Position position, float textWidthPercent) {
        super(text, FONT_COLOR, FONT_SHADOW_COLOR, FONT, 10);
        this.position = position;
        this.textWidthPercent = textWidthPercent;
    }

    public FixDrawTextItem(String text, Color fontColor, Color fontShadowColor, Font font, int minFontSize, Position position, float textWidthPercent) {
        super(text, fontColor, fontShadowColor, font, minFontSize);
        this.position = position;
        this.textWidthPercent = textWidthPercent;
    }

    public void drawText(Graphics2D graphics, int width, int height) {
        if (StringUtils.isBlank((String)this.text)) {
            return;
        }
        int x = 0;
        int y = 0;
        int fontsize = 1;
        if (this.position == Position.CENTER) {
            int textLength = (int)((float)width * this.textWidthPercent);
            fontsize = textLength / this.text.length();
            if (fontsize < this.minFontSize) {
                return;
            }
            float fsize = fontsize;
            Font font = this.defaultFont.deriveFont(fsize);
            graphics.setFont(font);
            FontRenderContext context = graphics.getFontRenderContext();
            int sw = (int)font.getStringBounds(this.text, context).getWidth();
            x = (width - sw) / 2;
            y = height / 2 + fontsize / 2;
        } else if (this.position == Position.TOP_LEFT) {
            fontsize = (int)((float)width * this.textWidthPercent) / this.text.length();
            if (fontsize < this.minFontSize) {
                return;
            }
            float fsize = fontsize;
            Font font = this.defaultFont.deriveFont(fsize);
            graphics.setFont(font);
            x = fontsize;
            y = fontsize * 2;
        } else if (this.position == Position.TOP_RIGHT) {
            fontsize = (int)((float)width * this.textWidthPercent) / this.text.length();
            if (fontsize < this.minFontSize) {
                return;
            }
            float fsize = fontsize;
            Font font = this.defaultFont.deriveFont(fsize);
            graphics.setFont(font);
            FontRenderContext context = graphics.getFontRenderContext();
            int sw = (int)font.getStringBounds(this.text, context).getWidth();
            x = width - sw - fontsize;
            y = fontsize * 2;
        } else if (this.position == Position.BOTTOM_LEFT) {
            fontsize = (int)((float)width * this.textWidthPercent) / this.text.length();
            if (fontsize < this.minFontSize) {
                return;
            }
            float fsize = fontsize;
            Font font = this.defaultFont.deriveFont(fsize);
            graphics.setFont(font);
            x = fontsize / 2;
            y = height - fontsize;
        } else if (this.position == Position.BOTTOM_RIGHT) {
            fontsize = (int)((float)width * this.textWidthPercent) / this.text.length();
            if (fontsize < this.minFontSize) {
                return;
            }
            float fsize = fontsize;
            Font font = this.defaultFont.deriveFont(fsize);
            graphics.setFont(font);
            FontRenderContext context = graphics.getFontRenderContext();
            int sw = (int)font.getStringBounds(this.text, context).getWidth();
            x = width - sw - fontsize;
            y = height - fontsize;
        } else {
            throw new IllegalArgumentException("Unknown position : " + (Object)((Object)this.position));
        }
        if (x <= 0 || y <= 0) {
            return;
        }
        if (this.fontShadowColor != null) {
            graphics.setColor(this.fontShadowColor);
            graphics.drawString(this.text, x + this.getShadowTranslation(fontsize), y + this.getShadowTranslation(fontsize));
        }
        graphics.setColor(this.fontColor);
        graphics.drawString(this.text, x, y);
    }

    public float getTextWidthPercent() {
        return this.textWidthPercent;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setTextWidthPercent(float textWidthPercent) {
        this.textWidthPercent = textWidthPercent;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        CENTER,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

