/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.codec.convertor;

import com.alibaba.simpleimage.codec.convertor.MapColorConvertor;

public class YCbCr2RGBColorConvertor
extends MapColorConvertor {
    public long convert(int[] input, int inPos) {
        int Y = input[inPos++] & 0xFF;
        int Cb = input[inPos++] & 0xFF;
        int Cr = input[inPos] & 0xFF;
        byte r = (byte)sampleRangeLimitTable[256 + Y + Cr2R[Cr]];
        byte g = (byte)sampleRangeLimitTable[256 + Y + (Cb2G[Cb] + Cr2G[Cr] >> 16)];
        byte b = (byte)sampleRangeLimitTable[256 + Y + Cb2B[Cb]];
        return 0xFF000000L | (long)((r & 0xFF) << 16) | (long)((g & 0xFF) << 8) | (long)(b & 0xFF);
    }

    public byte[] convertBlock(int[] input, int inPos, byte[] output, int numOfComponents, int startCoordinate, int row, int scanlineStride) {
        int index = 0;
        int inputOffset = 0;
        int bounds = 0;
        int len = output.length;
        for (int i = 0; i < 8; ++i) {
            index = startCoordinate + i * scanlineStride;
            bounds = row * scanlineStride;
            for (int j = 0; j < 8; ++j) {
                int Y = input[inputOffset++] & 0xFF;
                int Cb = input[inputOffset++] & 0xFF;
                int Cr = input[inputOffset++] & 0xFF;
                if (index >= len) {
                    return output;
                }
                if (index >= bounds) continue;
                output[index++] = (byte)sampleRangeLimitTable[256 + Y + Cr2R[Cr]];
                output[index++] = (byte)sampleRangeLimitTable[256 + Y + (Cb2G[Cb] + Cr2G[Cr] >> 16)];
                output[index++] = (byte)sampleRangeLimitTable[256 + Y + Cb2B[Cb]];
            }
            ++row;
        }
        return output;
    }
}

