/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.sift.match;

import com.alibaba.simpleimage.analyze.sift.scale.KDFeaturePoint;
import java.util.Comparator;

public class Match {
    int slopeArc;
    public KDFeaturePoint fp1;
    public KDFeaturePoint fp2;
    public float dist1;
    public float dist2;

    public Match(KDFeaturePoint fp1, KDFeaturePoint fp2, float dist1, float dist2) {
        this.fp1 = fp1;
        this.fp2 = fp2;
        this.dist1 = dist1;
        this.dist2 = dist2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatchWeighter
    implements Comparator<Match> {
        private float distExp;
        private float quotExp;

        public MatchWeighter() {
            this(1.0f, 1.0f);
        }

        public MatchWeighter(float distExp, float quotExp) {
            this.distExp = distExp;
            this.quotExp = quotExp;
        }

        public float OverallFitness(Match m) {
            float fitness = (float)(Math.pow(m.dist1, this.distExp) * Math.pow(1.0 / (double)(m.dist2 - m.dist1), this.quotExp));
            return fitness;
        }

        @Override
        public int compare(Match o1, Match o2) {
            float fit2;
            float fit1 = this.OverallFitness(o1);
            if (fit1 < (fit2 = this.OverallFitness(o2))) {
                return -1;
            }
            if (fit1 > fit2) {
                return 1;
            }
            return 0;
        }
    }
}

