/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.datasource.config;

import com.alibaba.cloud.sentinel.datasource.config.AbstractDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.ApolloDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.ConsulDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.FileDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.NacosDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.RedisDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.ZookeeperDataSourceProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.ObjectUtils;

public class DataSourcePropertiesConfiguration {
    private FileDataSourceProperties file;
    private NacosDataSourceProperties nacos;
    private ZookeeperDataSourceProperties zk;
    private ApolloDataSourceProperties apollo;
    private RedisDataSourceProperties redis;
    private ConsulDataSourceProperties consul;

    public DataSourcePropertiesConfiguration() {
    }

    public DataSourcePropertiesConfiguration(ConsulDataSourceProperties consul) {
        this.consul = consul;
    }

    public ConsulDataSourceProperties getConsul() {
        return this.consul;
    }

    public void setConsul(ConsulDataSourceProperties consul) {
        this.consul = consul;
    }

    public DataSourcePropertiesConfiguration(FileDataSourceProperties file) {
        this.file = file;
    }

    public DataSourcePropertiesConfiguration(NacosDataSourceProperties nacos) {
        this.nacos = nacos;
    }

    public DataSourcePropertiesConfiguration(ZookeeperDataSourceProperties zk) {
        this.zk = zk;
    }

    public DataSourcePropertiesConfiguration(ApolloDataSourceProperties apollo) {
        this.apollo = apollo;
    }

    public DataSourcePropertiesConfiguration(RedisDataSourceProperties redis) {
        this.redis = redis;
    }

    public FileDataSourceProperties getFile() {
        return this.file;
    }

    public void setFile(FileDataSourceProperties file) {
        this.file = file;
    }

    public NacosDataSourceProperties getNacos() {
        return this.nacos;
    }

    public void setNacos(NacosDataSourceProperties nacos) {
        this.nacos = nacos;
    }

    public ZookeeperDataSourceProperties getZk() {
        return this.zk;
    }

    public void setZk(ZookeeperDataSourceProperties zk) {
        this.zk = zk;
    }

    public ApolloDataSourceProperties getApollo() {
        return this.apollo;
    }

    public void setApollo(ApolloDataSourceProperties apollo) {
        this.apollo = apollo;
    }

    public RedisDataSourceProperties getRedis() {
        return this.redis;
    }

    public void setRedis(RedisDataSourceProperties redis) {
        this.redis = redis;
    }

    @JsonIgnore
    public List<String> getValidField() {
        return Arrays.stream(this.getClass().getDeclaredFields()).map(field -> {
            try {
                if (!ObjectUtils.isEmpty((Object)field.get(this))) {
                    return field.getName();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @JsonIgnore
    public AbstractDataSourceProperties getValidDataSourceProperties() {
        List<String> invalidFields = this.getValidField();
        if (invalidFields.size() == 1) {
            try {
                this.getClass().getDeclaredField(invalidFields.get(0)).setAccessible(true);
                return (AbstractDataSourceProperties)this.getClass().getDeclaredField(invalidFields.get(0)).get(this);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }
}

