/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.KeyValueStreamingChannel;
import com.lambdaworks.redis.protocol.CommandOutput;
import java.nio.ByteBuffer;

public class KeyValueStreamingOutput<K, V>
extends CommandOutput<K, V, Long> {
    private K key;
    private KeyValueStreamingChannel<K, V> channel;

    public KeyValueStreamingOutput(RedisCodec<K, V> codec, KeyValueStreamingChannel<K, V> channel) {
        super(codec, 0L);
        this.channel = channel;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.key == null) {
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        Object value = bytes == null ? null : (Object)this.codec.decodeValue(bytes);
        this.channel.onKeyValue(this.key, value);
        this.output = (Long)this.output + 1L;
        this.key = null;
    }
}

