/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.CloseEvents;
import com.lambdaworks.redis.Connections;
import com.lambdaworks.redis.PooledConnectionInvocationHandler;
import com.lambdaworks.redis.RedisConnectionProvider;
import com.lambdaworks.redis.RedisException;
import java.io.Closeable;
import java.lang.reflect.Proxy;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RedisConnectionPool<T>
implements Closeable {
    private final RedisConnectionProvider<T> redisConnectionProvider;
    private GenericObjectPool<T> objectPool;
    private CloseEvents closeEvents = new CloseEvents();

    public RedisConnectionPool(RedisConnectionProvider<T> redisConnectionProvider, int maxActive, int maxIdle, long maxWait) {
        this.redisConnectionProvider = redisConnectionProvider;
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxIdle(maxIdle);
        config.setMaxTotal(maxActive);
        config.setMaxWaitMillis(maxWait);
        config.setTestOnBorrow(true);
        this.objectPool = new GenericObjectPool(this.createFactory(redisConnectionProvider), config);
    }

    private PooledObjectFactory<T> createFactory(final RedisConnectionProvider<T> redisConnectionProvider) {
        return new BasePooledObjectFactory<T>(){

            public T create() throws Exception {
                Object connection = redisConnectionProvider.createConnection();
                PooledConnectionInvocationHandler h = new PooledConnectionInvocationHandler(connection, RedisConnectionPool.this);
                Object proxy = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{redisConnectionProvider.getComponentType()}, h);
                return proxy;
            }

            public PooledObject<T> wrap(T obj) {
                return new DefaultPooledObject(obj);
            }

            public boolean validateObject(PooledObject<T> p) {
                return Connections.isOpen(p.getObject());
            }

            public void destroyObject(PooledObject<T> p) throws Exception {
                Object object = p.getObject();
                if (Proxy.isProxyClass(object.getClass())) {
                    PooledConnectionInvocationHandler invocationHandler = (PooledConnectionInvocationHandler)((Object)Proxy.getInvocationHandler(object));
                    object = invocationHandler.getConnection();
                }
                Connections.close(object);
            }
        };
    }

    public T allocateConnection() {
        try {
            return (T)this.objectPool.borrowObject();
        }
        catch (RedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedisException(e.getMessage(), e);
        }
    }

    public void freeConnection(T t) {
        this.objectPool.returnObject(t);
    }

    public int getNumIdle() {
        return this.objectPool.getNumIdle();
    }

    public int getNumActive() {
        return this.objectPool.getNumActive();
    }

    @Override
    public void close() {
        this.objectPool.close();
        this.objectPool = null;
        this.closeEvents.fireEventClosed(this);
        this.closeEvents = null;
    }

    public Class<? extends T> getComponentType() {
        return this.redisConnectionProvider.getComponentType();
    }

    public void addListener(CloseEvents.CloseListener listener) {
        this.closeEvents.addListener(listener);
    }

    public void removeListener(CloseEvents.CloseListener listener) {
        this.closeEvents.removeListener(listener);
    }
}

