/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.threerings.util.MessageBundle;
import java.util.ArrayList;
import java.util.Calendar;

public class TimeUtil {
    public static final byte MILLISECOND = 0;
    public static final byte SECOND = 1;
    public static final byte MINUTE = 2;
    public static final byte HOUR = 3;
    public static final byte DAY = 4;
    protected static final byte MAX_UNIT = 4;

    public static int elapsedSeconds(long startStamp, long endStamp) {
        if (endStamp < startStamp) {
            throw new IllegalArgumentException("End time must be after start time [start=" + startStamp + ", end=" + endStamp + "]");
        }
        return (int)((endStamp - startStamp) / 1000L);
    }

    public static String getTimeOrderString(long duration, byte minUnit) {
        return TimeUtil.getTimeOrderString(duration, minUnit, (byte)4);
    }

    public static String getTimeOrderString(long duration, byte minUnit, byte maxUnit) {
        minUnit = (byte)Math.min(minUnit, maxUnit);
        maxUnit = (byte)Math.min(maxUnit, 4);
        byte uu = 0;
        while (uu <= 4) {
            int quantity = TimeUtil.getQuantityPerUnit(uu);
            if (minUnit <= uu && (duration < (long)quantity || maxUnit == uu)) {
                duration = Math.max(1L, duration);
                return MessageBundle.tcompose(TimeUtil.getTransKey(uu), (Object)String.valueOf(duration));
            }
            duration = Math.round(duration / (long)quantity);
            uu = (byte)(uu + 1);
        }
        Thread.dumpStack();
        return null;
    }

    public static String getTimeString(long duration, byte minUnit) {
        return TimeUtil.getTimeString(duration, minUnit, false);
    }

    public static String getTimeString(long duration, byte minUnit, boolean roundUp) {
        byte uu;
        minUnit = (byte)Math.min(minUnit, 4);
        duration = Math.abs(duration);
        if (roundUp) {
            long quantity = 1L;
            uu = 0;
            while (uu < 3) {
                quantity *= (long)TimeUtil.getQuantityPerUnit(uu);
                uu = (byte)(uu + 1);
            }
            if (duration % quantity > 0L) {
                duration += quantity;
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        int parts = 0;
        uu = 0;
        while (uu <= 4) {
            long amt;
            int quantity = TimeUtil.getQuantityPerUnit(uu);
            if (minUnit <= uu && (amt = duration % (long)quantity) != 0L) {
                list.add(MessageBundle.tcompose(TimeUtil.getTransKey(uu), (Object)String.valueOf(amt)));
                ++parts;
            }
            if ((duration /= (long)quantity) <= 0L && parts > 0) break;
            uu = (byte)(uu + 1);
        }
        if (parts == 0) {
            return MessageBundle.tcompose(TimeUtil.getTransKey(minUnit), (Object)0);
        }
        if (parts == 1) {
            return (String)list.get(0);
        }
        return MessageBundle.compose("m.times_" + parts, list.toArray());
    }

    protected static int getQuantityPerUnit(byte unit) {
        switch (unit) {
            case 0: {
                return 1000;
            }
            case 1: 
            case 2: {
                return 60;
            }
            case 3: {
                return 24;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        return -1;
    }

    protected static String getTransKey(byte unit) {
        switch (unit) {
            case 0: {
                return "m.millisecond";
            }
            case 1: {
                return "m.second";
            }
            case 2: {
                return "m.minute";
            }
            case 3: {
                return "m.hour";
            }
            case 4: {
                return "m.day";
            }
        }
        return null;
    }

    public static Calendar getLastDayOfWeekInMonth(int year, int month, int DAY_OF_WEAK) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        int day = 0;
        day = cal.get(7);
        if (day >= DAY_OF_WEAK) {
            cal.set(5, lastDay - (day - DAY_OF_WEAK));
        } else {
            cal.set(5, lastDay - (7 + day - DAY_OF_WEAK));
        }
        return cal;
    }

    public static void main(String[] args) {
        System.out.println(TimeUtil.getLastDayOfWeekInMonth(2020, 0, 1).getTime());
        System.out.println(TimeUtil.getLastDayOfWeekInMonth(2020, 1, 1).getTime());
        System.out.println(TimeUtil.getLastDayOfWeekInMonth(2020, 2, 1).getTime());
        System.out.println(TimeUtil.getLastDayOfWeekInMonth(2020, 3, 1).getTime());
    }
}

