/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.util.StringUtil;
import com.threerings.resource.ResourceManager;
import com.threerings.util.Log;
import com.threerings.util.MessageBundle;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class MessageManager {
    private static final String PROPERTIES = "properties";
    public static final String GLOBAL_BUNDLE = "global";
    protected String _prefix;
    protected Locale _locale;
    protected ClassLoader _loader;
    protected HashMap<String, MessageBundle> _cache = new HashMap();
    protected MessageBundle _global;
    private ResourceManager _rsrcMgr;
    protected static final String MBUNDLE_CLASS_KEY = "msgbundle_class";

    public MessageManager(String resourcePrefix) {
        this(resourcePrefix, null);
    }

    public MessageManager(String resourcePrefix, ResourceManager rsrcMgr) {
        this._rsrcMgr = rsrcMgr;
        this._prefix = resourcePrefix;
        this._locale = Locale.getDefault();
        Log.log.debug((Object)("Using locale: " + this._locale + "."), new Object[0]);
        if (!this._prefix.endsWith(".")) {
            this._prefix = String.valueOf(this._prefix) + ".";
        }
        this._global = this.getBundle(GLOBAL_BUNDLE);
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this.setLocale(locale, false);
    }

    public void setLocale(Locale locale, boolean updateGlobal) {
        this._locale = locale;
        this._cache.clear();
        if (updateGlobal) {
            this._global = this.getBundle(GLOBAL_BUNDLE);
        }
    }

    public void setPrefix(String resourcePrefix) {
        this._prefix = resourcePrefix;
        this._global = this.getBundle(GLOBAL_BUNDLE);
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public MessageBundle getBundle(String path) {
        MessageBundle bundle = this._cache.get(path);
        if (bundle != null) {
            return bundle;
        }
        ResourceBundle rbundle = this.loadBundle(String.valueOf(this._prefix) + path);
        MessageBundle customBundle = null;
        if (rbundle != null) {
            String mbclass = null;
            try {
                mbclass = rbundle.getString(MBUNDLE_CLASS_KEY).trim();
                if (!StringUtil.isBlank((String)mbclass)) {
                    customBundle = (MessageBundle)Class.forName(mbclass).newInstance();
                }
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Failure instantiating custom message bundle", new Object[]{"mbclass", mbclass, "error", t});
            }
        }
        bundle = this.createBundle(path, rbundle, customBundle);
        this._cache.put(path, bundle);
        return bundle;
    }

    protected MessageBundle createBundle(String path, ResourceBundle rbundle, MessageBundle customBundle) {
        if (customBundle == null) {
            customBundle = new MessageBundle();
        }
        this.initBundle(customBundle, path, rbundle);
        return customBundle;
    }

    protected void initBundle(MessageBundle bundle, String path, ResourceBundle rbundle) {
        bundle.init(this, path, rbundle, this._global);
    }

    /*
     * Loose catch block
     */
    protected ResourceBundle loadBundle(String path) {
        if (this._rsrcMgr != null) {
            PropertyResourceBundle propertyResourceBundle;
            InputStream in;
            block20: {
                block18: {
                    block19: {
                        in = null;
                        in = this.getResource(path, this._locale);
                        if (in != null) break block18;
                        Log.log.warning((Object)"Unable to resolve resource bundle", new Object[]{"path", path, "locale", this._locale});
                        if (in == null) break block19;
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Log.log.warning((Object)"Unable to close inputstream", new Object[]{"path", path, e});
                        }
                    }
                    return null;
                }
                propertyResourceBundle = new PropertyResourceBundle(in);
                if (in == null) break block20;
                try {
                    in.close();
                }
                catch (IOException e) {
                    Log.log.warning((Object)"Unable to close inputstream", new Object[]{"path", path, e});
                }
            }
            return propertyResourceBundle;
            catch (IOException e) {
                block21: {
                    try {
                        Log.log.warning((Object)"Unable to resolve resource bundle", new Object[]{"path", path, "locale", this._locale, e});
                        if (in == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                Log.log.warning((Object)"Unable to close inputstream", new Object[]{"path", path, e2});
                            }
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        Log.log.warning((Object)"Unable to close inputstream", new Object[]{"path", path, e3});
                    }
                }
                return null;
            }
        }
        try {
            if (this._loader != null) {
                return ResourceBundle.getBundle(path, this._locale, this._loader);
            }
            return ResourceBundle.getBundle(path, this._locale);
        }
        catch (MissingResourceException mre) {
            Log.log.warning((Object)"Unable to resolve resource bundle", new Object[]{"path", path, "locale", this._locale, mre});
            return null;
        }
    }

    public MessageBundle getBundle(String path, String language) {
        ResourceBundle rbundle = this.loadBundle(path, language);
        MessageBundle customBundle = null;
        if (rbundle != null) {
            String mbclass = null;
            try {
                mbclass = rbundle.getString(MBUNDLE_CLASS_KEY).trim();
                if (!StringUtil.isBlank((String)mbclass)) {
                    customBundle = (MessageBundle)Class.forName(mbclass).newInstance();
                }
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Failure instantiating custom message bundle", new Object[]{"mbclass", mbclass, "error", t});
            }
        }
        MessageBundle bundle = this.createBundle(path, rbundle, customBundle);
        return bundle;
    }

    /*
     * Loose catch block
     */
    public ResourceBundle loadBundle(String name, String language) {
        String path = String.valueOf(this._prefix) + name;
        if (this._rsrcMgr != null) {
            PropertyResourceBundle propertyResourceBundle;
            InputStream in;
            block21: {
                block19: {
                    block20: {
                        in = null;
                        String resourceName = this.toResourceName(this.toBundleName(path, language, null, null, null), PROPERTIES);
                        in = this._rsrcMgr.getResource(resourceName);
                        if (in == null) {
                            resourceName = this.toResourceName(this.toBundleName(path, null, null, null, null), PROPERTIES);
                            in = this._rsrcMgr.getResource(resourceName);
                        }
                        if (in != null) break block19;
                        Log.log.warning((Object)"Unable to resolve resource bundle", new Object[]{"path", path, "language", language});
                        if (in == null) break block20;
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Log.log.warning((Object)"Unable to close inputstream", new Object[]{"path", path, e});
                        }
                    }
                    return null;
                }
                propertyResourceBundle = new PropertyResourceBundle(in);
                if (in == null) break block21;
                try {
                    in.close();
                }
                catch (IOException e) {
                    Log.log.warning((Object)"Unable to close inputstream", new Object[]{"path", path, e});
                }
            }
            return propertyResourceBundle;
            catch (IOException e) {
                block22: {
                    try {
                        Log.log.warning((Object)"Unable to resolve resource bundle", new Object[]{"path", path, "language", language, e});
                        if (in == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                Log.log.warning((Object)"Unable to close inputstream", new Object[]{"path", path, e2});
                            }
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        Log.log.warning((Object)"Unable to close inputstream", new Object[]{"path", path, e3});
                    }
                }
                return null;
            }
        }
        Locale local = new Locale(language, null);
        try {
            if (this._loader != null) {
                return ResourceBundle.getBundle(path, local, this._loader);
            }
            return ResourceBundle.getBundle(path, local);
        }
        catch (MissingResourceException mre) {
            Log.log.warning((Object)"Unable to resolve resource bundle", new Object[]{"path", path, "locale", this._locale, mre});
            return null;
        }
    }

    protected InputStream getResource(String baseName, Locale locale) throws IOException {
        if (locale == Locale.ROOT) {
            return this._rsrcMgr.getResource(baseName);
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String resourceName = this.toResourceName(this.toBundleName(baseName, language, null, country, null), PROPERTIES);
        InputStream in = null;
        try {
            in = this._rsrcMgr.getResource(resourceName);
            if (in == null && (in = this._rsrcMgr.getResource(resourceName = this.toResourceName(this.toBundleName(baseName, language, null, null, null), PROPERTIES))) == null) {
                resourceName = this.toResourceName(this.toBundleName(baseName, null, null, null, null), PROPERTIES);
                in = this._rsrcMgr.getResource(resourceName);
            }
        }
        catch (IOException e) {
            resourceName = this.toResourceName(this.toBundleName(baseName, language, null, null, null), PROPERTIES);
            try {
                in = this._rsrcMgr.getResource(resourceName);
            }
            catch (IOException e1) {
                resourceName = this.toResourceName(this.toBundleName(baseName, null, null, null, null), PROPERTIES);
                in = this._rsrcMgr.getResource(resourceName);
            }
        }
        return in;
    }

    public String toBundleName(String baseName, String language, String script, String country, String variant) {
        if (!(language != "" && language != null || country != "" && country != null || variant != "" && variant != null)) {
            return baseName;
        }
        StringBuilder sb = new StringBuilder(baseName);
        sb.append('_');
        if (script != null && !script.equals("")) {
            if (variant != null && !variant.equals("")) {
                sb.append(language).append('_').append(script).append('_').append(country).append('_').append(variant);
            } else if (country != null && !country.equals("")) {
                sb.append(language).append('_').append(script).append('_').append(country);
            } else {
                sb.append(language).append('_').append(script);
            }
        } else if (variant != null && !variant.equals("")) {
            sb.append(language).append('_').append(country).append('_').append(variant);
        } else if (country != null && !country.equals("")) {
            sb.append(language).append('_').append(country);
        } else {
            sb.append(language);
        }
        return sb.toString();
    }

    public final String toResourceName(String bundleName, String suffix) {
        StringBuilder sb = new StringBuilder(bundleName.length() + 1 + suffix.length());
        sb.append(bundleName.replace('.', '/')).append('.').append(suffix);
        return sb.toString();
    }
}

