/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

public class BitMap {
    byte[] bitMap;
    int defaultCapacity;
    int capacity;
    int limitPos;

    protected BitMap() {
    }

    public BitMap(int size) {
        int words = size / 8;
        if (size % 32 != 0) {
            ++words;
        }
        this.defaultCapacity = this.capacity = words * 8;
        this.bitMap = new byte[words];
        this.limitPos = 0;
    }

    public BitMap(byte[] map) {
        this.bitMap = map;
        this.defaultCapacity = this.capacity = map.length * 8;
        this.limitPos = 0;
    }

    public int size() {
        return this.capacity;
    }

    public void reset() {
        this.bitMap = new byte[this.defaultCapacity / 8];
        this.capacity = this.defaultCapacity;
        this.limitPos = 0;
    }

    public int getPos() {
        return this.limitPos;
    }

    public byte set(int pos) {
        BitMap.set(this.bitMap, pos);
        this.limitPos = pos;
        return this.bitMap[pos / 8];
    }

    public byte unset(int pos) {
        BitMap.unset(this.bitMap, pos);
        return this.bitMap[pos / 8];
    }

    public boolean isSet(int pos) {
        return BitMap.isSet(this.bitMap, pos);
    }

    public byte[] getBytes() {
        return this.bitMap;
    }

    public byte get(int pos) {
        return this.bitMap[pos / 8];
    }

    public static int setByte(int map, byte value, int pos) {
        int intValue = (value & 0xFF) << 24 - pos;
        int mask = -16777216 >>> pos;
        return (map &= (mask ^= 0xFFFFFFFF)) | intValue;
    }

    public static int set(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return map | mask;
    }

    public static byte set(byte map, int pos) {
        int mask = 128 >>> pos;
        return (byte)(map | mask);
    }

    public static int unset(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return map & (mask ^= 0xFFFFFFFF);
    }

    public static boolean isSet(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return (map & mask) != 0;
    }

    public static boolean isSet(byte map, int pos) {
        int mask = 128 >>> pos;
        return (map & mask) != 0;
    }

    public static boolean isSet(byte[] map, int pos) {
        int mask = 128 >>> (pos & 7);
        int index = pos / 8;
        if (index >= map.length) {
            return false;
        }
        byte b = map[index];
        return (b & mask) != 0;
    }

    public static void unset(byte[] map, int pos) {
        int mask = 128 >>> (pos & 7);
        mask ^= 0xFFFFFFFF;
        int index = pos / 8;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        map[index] = (byte)(b & mask);
    }

    public static void set(byte[] map, int pos) {
        int mask = 128 >>> (pos & 7);
        int index = pos / 8;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        map[index] = (byte)(b | mask);
    }

    public static void and(byte[] map, int pos, byte source, int count) {
        int shift = pos & 7;
        int mask = (source & 0xFF) >>> shift;
        int innermask = 255 >> shift;
        int index = pos / 8;
        if (count < 8) {
            innermask >>>= 8 - count;
            innermask <<= 8 - count;
        }
        mask &= innermask;
        innermask ^= 0xFFFFFFFF;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        map[index] = (byte)(b & innermask);
        b = (byte)(b & mask);
        map[index] = (byte)(map[index] | b);
        if (shift == 0) {
            return;
        }
        if (count > (shift = 8 - shift)) {
            mask = (source & 0xFF) << 8 >>> shift;
            innermask = 65280 >>> shift;
            b = map[index + 1];
            map[index + 1] = (byte)(b & (innermask ^= 0xFFFFFFFF));
            b = (byte)(b & mask);
            map[index + 1] = (byte)(map[index + 1] | b);
        }
    }

    public static void or(byte[] map, int pos, byte source, int count) {
        byte b;
        int shift = pos & 7;
        int mask = (source & 0xFF) >>> shift;
        int index = pos / 8;
        if (index >= map.length) {
            return;
        }
        map[index] = b = (byte)(map[index] | mask);
        if (shift == 0) {
            return;
        }
        if (count > (shift = 8 - shift)) {
            mask = (source & 0xFF) << 8 >>> shift;
            map[index + 1] = b = (byte)(map[index + 1] | mask);
        }
    }

    public static void overlay(byte[] map, int pos, byte source, int count) {
        int shift = pos & 7;
        int mask = (source & 0xFF) >>> shift;
        int innermask = 255 >> shift;
        int index = pos / 8;
        if (count < 8) {
            innermask >>>= 8 - count;
            innermask <<= 8 - count;
        }
        mask &= innermask;
        innermask ^= 0xFFFFFFFF;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        b = (byte)(b & innermask);
        map[index] = (byte)(b | mask);
        if (shift == 0) {
            return;
        }
        if (count > (shift = 8 - shift)) {
            mask = (source & 0xFF) << 8 >>> shift;
            innermask = 65280 >>> shift;
            b = map[index + 1];
            b = (byte)(b & (innermask ^= 0xFFFFFFFF));
            map[index + 1] = (byte)(b | mask);
        }
    }

    public static int compare(byte[] a, byte[] b) {
        int shortLength = a.length > b.length ? b.length : a.length;
        int i = 0;
        while (i < shortLength) {
            if (a[i] != b[i]) {
                return (a[i] & 0xFF) > (b[i] & 0xFF) ? 1 : -1;
            }
            ++i;
        }
        if (a.length == b.length) {
            return 0;
        }
        return a.length > b.length ? 1 : -1;
    }

    public static byte[] and(byte[] a, byte[] b) {
        int length = a.length > b.length ? a.length : b.length;
        int shortLength = a.length > b.length ? b.length : a.length;
        byte[] map = new byte[length];
        int i = 0;
        while (i < shortLength) {
            map[i] = (byte)(a[i] & b[i]);
            ++i;
        }
        return map;
    }

    public static byte[] or(byte[] a, byte[] b) {
        int length = a.length > b.length ? a.length : b.length;
        int shortLength = a.length > b.length ? b.length : a.length;
        byte[] map = new byte[length];
        if (length != shortLength) {
            byte[] source = a.length > b.length ? a : b;
            System.arraycopy(source, shortLength, map, shortLength, length - shortLength);
        }
        int i = 0;
        while (i < shortLength) {
            map[i] = (byte)(a[i] | b[i]);
            ++i;
        }
        return map;
    }

    public static byte[] xor(byte[] a, byte[] b) {
        int length = a.length > b.length ? a.length : b.length;
        int shortLength = a.length > b.length ? b.length : a.length;
        byte[] map = new byte[length];
        if (length != shortLength) {
            byte[] source = a.length > b.length ? a : b;
            System.arraycopy(source, shortLength, map, shortLength, length - shortLength);
        }
        int i = 0;
        while (i < shortLength) {
            map[i] = (byte)(a[i] ^ b[i]);
            ++i;
        }
        return map;
    }

    public static byte[] not(byte[] a) {
        byte[] map = new byte[a.length];
        int i = 0;
        while (i < a.length) {
            map[i] = ~a[i];
            ++i;
        }
        return map;
    }

    public static boolean hasAnyBitSet(byte[] map) {
        int i = 0;
        while (i < map.length) {
            if (map[i] != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static byte[] leftShift(byte[] map, int shiftBits) {
        byte[] newMap = new byte[map.length];
        int shiftBytes = shiftBits / 8;
        if (shiftBytes >= map.length) {
            return newMap;
        }
        if ((shiftBits %= 8) == 0) {
            int i = 0;
            int j = shiftBytes;
            while (j < map.length) {
                newMap[i] = map[j];
                ++i;
                ++j;
            }
        } else {
            int i = 0;
            int j = shiftBytes;
            while (j < map.length) {
                int shifted = (map[j] & 0xFF) << shiftBits;
                newMap[i] = (byte)shifted;
                if (i > 0) {
                    int n = i - 1;
                    newMap[n] = (byte)(newMap[n] | (byte)(shifted >>> 8));
                }
                ++i;
                ++j;
            }
        }
        return newMap;
    }
}

