/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.util;

import com.threerings.resource.util.Hash;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;

public class RequiredResourceIndex {
    private static final long HEADER_SIZE = 4L;
    private Set<Hash> mapHash = new HashSet<Hash>();

    public void addResource(String resource) {
        this.addResource(new Hash(resource));
    }

    public void addResource(Hash hash) {
        if (!this.mapHash.contains(hash)) {
            this.mapHash.add(hash);
        }
    }

    public Set<Hash> getResourceHash() {
        return this.mapHash;
    }

    public void fromFile(File file) throws IOException {
        this.mapHash.clear();
        if (!file.exists()) {
            throw new IOException("File not Found:" + file.getAbsolutePath());
        }
        try (RandomAccessFile fileAccess = null;){
            fileAccess = new RandomAccessFile(file, "rw");
            if (fileAccess.length() < 4L) {
                fileAccess.seek(0L);
                fileAccess.writeInt(0);
            }
            fileAccess.seek(0L);
            int entrySize = fileAccess.readInt();
            int i = 0;
            while (i < entrySize) {
                this.mapHash.add(new Hash(fileAccess.readInt(), fileAccess.readInt()));
                ++i;
            }
        }
    }

    public void fromInputStream(InputStream in) throws IOException {
        if (in == null) {
            return;
        }
        this.mapHash.clear();
        try (DataInputStream ds = null;){
            ds = new DataInputStream(in);
            int entrySize = ds.readInt();
            int i = 0;
            while (i < entrySize) {
                this.mapHash.add(new Hash(ds.readInt(), ds.readInt()));
                ++i;
            }
        }
    }

    public void saveToFile(File dest) throws IOException {
        if (dest.exists()) {
            dest.delete();
        }
        try (RandomAccessFile fileAccess = null;){
            fileAccess = new RandomAccessFile(dest, "rw");
            fileAccess.seek(0L);
            fileAccess.writeInt(this.mapHash.size());
            for (Hash hash : this.mapHash) {
                fileAccess.writeInt(hash.hashA);
                fileAccess.writeInt(hash.hashB);
            }
            fileAccess.getChannel().force(true);
        }
    }
}

