/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class MD5InputStream
extends InputStream {
    private MessageDigest md5;
    private InputStream in;

    public MD5InputStream(InputStream in) throws IOException {
        this.init();
        this.in = in;
    }

    private void init() throws IOException {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.md5.update((byte)(b & 0xFF));
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        if (r != -1) {
            this.md5.update(b, 0, r);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r != -1) {
            this.md5.update(b, off, r);
        }
        return r;
    }

    public byte[] getDigest() {
        return this.md5.digest();
    }
}

