/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;

public class MD5FileInputStream
extends FileInputStream {
    private MessageDigest md5;

    public MD5FileInputStream(File file) throws IOException {
        super(file);
        this.init();
    }

    public MD5FileInputStream(String file) throws IOException {
        super(file);
        this.init();
    }

    public MD5FileInputStream(FileDescriptor file) throws IOException {
        super(file);
        this.init();
    }

    private void init() throws IOException {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        byte b = (byte)super.read();
        if (b != -1 || this.available() > 0) {
            this.md5.update(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = super.read(b);
        if (r != -1) {
            this.md5.update(b, 0, r);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = super.read(b, off, len);
        if (r != -1) {
            this.md5.update(b, off, r);
        }
        return r;
    }

    public byte[] getDigest() {
        return this.md5.digest();
    }
}

