/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.util;

import com.threerings.resource.util.MD5FileInputStream;
import com.threerings.resource.util.MD5InputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public class HashFile {
    public static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] getHash(InputStream fis, String hashType) throws Exception {
        byte[] buffer = new byte[4096];
        MessageDigest md5 = MessageDigest.getInstance(hashType);
        int numRead = 0;
        while ((numRead = fis.read(buffer)) != -1) {
            md5.update(buffer, 0, numRead);
        }
        return md5.digest();
    }

    public static byte[] getHash(File file, String hashType) throws Exception {
        try (InputStream fis = null;){
            fis = new FileInputStream(file);
            byte[] byArray = HashFile.getHash(fis, hashType);
            return byArray;
        }
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        int i = 0;
        while (i < b.length) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        File file = new File("D:/Projects/knight/rsrc.raz.block");
        System.out.println(HashFile.toHexString(HashFile.getHash(file, "MD5")));
        MD5FileInputStream fis = new MD5FileInputStream(file);
        System.out.println(HashFile.toHexString(HashFile.getHash(fis, "MD5")));
        System.out.println(HashFile.toHexString(fis.getDigest()));
        fis.close();
        FileInputStream newaa = new FileInputStream(file);
        System.out.println(((InputStream)newaa).read());
        MD5InputStream mfis = new MD5InputStream(new FileInputStream(file));
        System.out.println(HashFile.toHexString(HashFile.getHash(mfis, "MD5")));
        System.out.println(HashFile.toHexString(mfis.getDigest()));
    }
}

