/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.util;

public class Hash {
    static final int[] cryptTable = new int[65535];
    public int hashA;
    public int hashB;

    static {
        int seed = 0x100001;
        int index1 = 0;
        while (index1 < 256) {
            int index2 = index1;
            int i = 0;
            while (i < 5) {
                seed = (seed * 125 + 3) % 0x2AAAAB;
                int temp1 = (seed & 0xFFFF) << 16;
                seed = (seed * 125 + 3) % 0x2AAAAB;
                int temp2 = seed & 0xFFFF;
                Hash.cryptTable[index2] = temp1 | temp2;
                ++i;
                index2 += 256;
            }
            ++index1;
        }
    }

    public Hash(int code1, int code2) {
        this.hashA = code1;
        this.hashB = code2;
    }

    public Hash(String str) {
        this(Hash.hashString(str, 1), Hash.hashString(str, 2));
    }

    public Hash() {
    }

    public int hashCode() {
        return this.hashB;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Hash) {
            Hash that = (Hash)o;
            return this.hashA == that.hashA && this.hashB == that.hashB;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(Integer.toString(this.hashA, 16)) + "_" + Integer.toString(this.hashB, 16);
    }

    public static Hash toHash(String path) {
        return new Hash(Hash.hashString(path, 1), Hash.hashString(path, 2));
    }

    public static int hashString(String string, int hashType) {
        int seed1 = 2146271213;
        int seed2 = -286331154;
        string = string.toUpperCase();
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            seed1 = cryptTable[hashType * 256 + ch] ^ seed1 + seed2;
            seed2 = ch + seed1 + seed2 + (seed2 << 5) + 3;
            ++i;
        }
        return seed1;
    }
}

