/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;

public class CRC32FileInputStream
extends FileInputStream {
    private CRC32 crc;

    public CRC32FileInputStream(File file) throws IOException {
        super(file);
        this.init();
    }

    public CRC32FileInputStream(String file) throws IOException {
        super(file);
        this.init();
    }

    public CRC32FileInputStream(FileDescriptor file) throws IOException {
        super(file);
        this.init();
    }

    private void init() {
        this.crc = new CRC32();
    }

    @Override
    public int read() throws IOException {
        byte b = (byte)super.read();
        if (b != -1) {
            this.crc.update(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = super.read(b);
        if (r != -1) {
            this.crc.update(b, 0, r);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = super.read(b, off, len);
        if (r != -1) {
            this.crc.update(b, off, r);
        }
        return r;
    }

    public long getCRCValue() {
        return this.crc.getValue();
    }
}

