/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayStoredInputStream
extends InputStream {
    private ByteArrayOutputStream bos;
    private InputStream in;
    private Closer closer;
    private boolean closed;

    public ByteArrayStoredInputStream(InputStream in, Closer closer) throws IOException {
        this.init();
        this.in = in;
        this.closer = closer;
    }

    private void init() {
        this.bos = new ByteArrayOutputStream();
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.bos.write((byte)(b & 0xFF));
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        if (r != -1) {
            this.bos.write(b, 0, r);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r != -1) {
            this.bos.write(b, off, r);
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.in.available() > 0) {
            byte[] b = new byte[32];
            int size = 0;
            do {
                size = this.in.read(b);
                this.bos.write(b, 0, size);
            } while (this.in.available() > 0);
        }
        this.closer.onClose(this.bos.toByteArray());
        this.in.close();
        this.closed = true;
    }

    public static interface Closer {
        public void onClose(byte[] var1) throws IOException;
    }
}

