/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource;

import com.samskivert.util.StringUtil;
import com.threerings.resource.Log;
import com.threerings.resource.ResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;

public class ResourceHandler
extends URLStreamHandler {
    public static String RESOURCE_PROTOCOL = "resource";
    protected ResourceManager _rmgr;

    public void setResourceManager(ResourceManager _rmgr) {
        this._rmgr = _rmgr;
    }

    @Override
    protected int hashCode(URL url) {
        return String.valueOf(url).hashCode();
    }

    @Override
    protected boolean equals(URL u1, URL u2) {
        return String.valueOf(u1).equals(String.valueOf(u2));
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new URLConnection(url){
            protected InputStream _stream;

            @Override
            public void connect() throws IOException {
                String bundle = this.url.getHost();
                String path = this.url.getPath().substring(1);
                try {
                    String query = this.url.getQuery();
                    this._stream = !StringUtil.isBlank((String)query) ? ResourceHandler.this.getStream(bundle, path, query) : (StringUtil.isBlank((String)bundle) ? ResourceHandler.this._rmgr.getResource(path) : ResourceHandler.this._rmgr.getResource(bundle, path));
                    this.connected = true;
                }
                catch (IOException ioe) {
                    Log.log.warning((Object)"Could not find resource", new Object[]{"url", this.url, "error", ioe.getMessage()});
                    throw ioe;
                }
            }

            @Override
            public InputStream getInputStream() throws IOException {
                if (!this.connected) {
                    this.connect();
                }
                return this._stream;
            }

            @Override
            public Permission getPermission() throws IOException {
                return null;
            }
        };
    }

    protected InputStream getStream(String bundle, String path, String query) throws IOException {
        Log.log.warning((Object)("Requested sub-tile class=" + this.getClass() + " is not support"), new Object[]{"bundle", bundle, "path", path, "dims", query});
        return this._rmgr.getResource(bundle, path);
    }
}

