package com.threerings.resource.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * SceneMap resources Persistence tools  
 * @author Bluse
 *
 */
public class RequiredResourceIndex {
	private static final long HEADER_SIZE = 4;
	private Set<Hash> mapHash = new HashSet<Hash>();
	
	
	public void addResource(String resource) {
		addResource(new Hash(resource));
	}
	
	public void addResource(Hash hash) {
		
		if(!mapHash.contains(hash)) {
			mapHash.add(hash);
		}
	}
	
	public Set<Hash> getResourceHash(){
		return mapHash;
	}
	
	public void fromFile(File file) throws IOException {
		mapHash.clear();
		if(!file.exists()) {
			throw new IOException("File not Found:"+file.getAbsolutePath());
		}
		RandomAccessFile fileAccess = null;
		try {
			
			fileAccess = new RandomAccessFile(file, "rw");
			if (fileAccess.length() < HEADER_SIZE) {
				fileAccess.seek(0);
				fileAccess.writeInt(0);
			}
			
			fileAccess.seek(0);
			int entrySize = fileAccess.readInt();
			
			for(int i=0;i<entrySize ;i++) {
				mapHash.add(new Hash(fileAccess.readInt(),fileAccess.readInt()));
			}
		}finally {
			if(fileAccess != null) {
				fileAccess.close();
			}
		}
	}
	
	/**
	 * InputStream will be closed after the method invoked
	 * @param in
	 * @throws IOException
	 */
	public void fromInputStream(InputStream in) throws IOException {
		if(in == null) {
			return;
		}
		DataInputStream ds = null;
		mapHash.clear();
		try {
			ds = new DataInputStream(in);
			int entrySize = ds.readInt();
			
			for(int i=0;i<entrySize ;i++) {
				mapHash.add(new Hash(ds.readInt(),ds.readInt()));
			}
		}finally {
			if(ds != null) {
				ds.close();
			}
		}
	}
	
	/**
	 * Save data to the destination file
	 * @param dest
	 * @throws IOException
	 */
	public void saveToFile(File dest) throws IOException {
		if(dest.exists()) {
			dest.delete();
		}
		RandomAccessFile fileAccess = null;
		try {
			fileAccess = new RandomAccessFile(dest, "rw");
			fileAccess.seek(0);
			fileAccess.writeInt(mapHash.size());
			Iterator<Hash> s = mapHash.iterator();
			while (s.hasNext()) {
				Hash hash = s.next();
				fileAccess.writeInt(hash.hashA);
				fileAccess.writeInt(hash.hashB);
			}
			fileAccess.getChannel().force(true);
		}finally {
			if(fileAccess != null) {
				fileAccess.close();
			}
		}
	}
}
