package com.threerings.resource.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

/**
 *  可以统计MD5值的输入流
 *  在流读取结束以后可以得到MD5值
* @author Bluse
*
*/
public class MD5InputStream extends InputStream {
	private MessageDigest md5;
	private InputStream in;
	public MD5InputStream(InputStream in) throws IOException {
		init();
		this.in = in;
	}

	private void init() throws IOException {
		try {
			md5 = MessageDigest.getInstance("MD5");
		} catch (Exception e) {
			throw new IOException(e);
		}
	}

	public int read() throws IOException {
		int b = in.read();
		if(b != -1){
			md5.update((byte)(b & 0xFF));
		}
		return b;
	}

	
	public int read(byte b[]) throws IOException {
		int r = in.read(b);
		if(r != -1){
			md5.update(b, 0, r);
		}
		return r;
    }
	
	public int read(byte b[], int off, int len) throws IOException {
		int r = in.read(b, off, len);
		if(r != -1){
			md5.update(b, off, r);
		}
		return r;
	}
	
	public byte[] getDigest() {
		return md5.digest();
	}
}
