package com.threerings.resource.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;

/**
  *  可以统计MD5值的文件输入流
  *  在流读取结束以后可以得到MD5值
 * @author Bluse
 *
 */
public class MD5FileInputStream extends FileInputStream {
	private MessageDigest md5;

	public MD5FileInputStream(File file) throws IOException {
		super(file);
		init();
	}

	public MD5FileInputStream(String file) throws IOException {
		super(file);
		init();
	}

	public MD5FileInputStream(FileDescriptor file) throws IOException {
		super(file);
		init();
	}

	private void init() throws IOException {
		try {
			md5 = MessageDigest.getInstance("MD5");
		} catch (Exception e) {
			throw new IOException(e);
		}
	}

	public int read() throws IOException {
		byte b = (byte) super.read();
		if(b != -1 || this.available()>0){
			md5.update(b);
		}
		return b;
	}

	public int read(byte b[]) throws IOException {
		int r = super.read(b);
		if(r != -1){
			md5.update(b, 0, r);
		}
		return r;

	}

	public int read(byte b[], int off, int len) throws IOException {
		int r = super.read(b, off, len);
		if(r != -1){
			md5.update(b, off, r);
		}
		return r;
	}

	public byte[] getDigest() {
		return md5.digest();
	}
}
