package com.threerings.resource.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public class HashFile {

	/**
	 * @param args
	 */
	public static char[] hexChar = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

	public static byte[] getHash(InputStream fis, String hashType) throws Exception {
		byte[] buffer = new byte[4096];
		MessageDigest md5 = MessageDigest.getInstance(hashType);
		int numRead = 0;
		while ((numRead = fis.read(buffer)) != -1) {
			md5.update(buffer, 0, numRead);
		}
		return md5.digest();
	}
	
	public static byte[] getHash(File file, String hashType) throws Exception {
		InputStream fis = null;
		try{
			fis = new FileInputStream(file);
			return getHash(fis,hashType);
		}catch(Exception e){
			throw e;
		}finally{
			fis.close();
		}
	}

	public static String toHexString(byte[] b) {
		StringBuilder sb = new StringBuilder(b.length * 2);
		for (int i = 0; i < b.length; i++) {
			sb.append(hexChar[(b[i] & 0xf0) >>> 4]);
			sb.append(hexChar[b[i] & 0x0f]);
		}
		return sb.toString();
	}
	
	public static void main(String[] args) throws Exception {
		File file = new File("D:/Projects/knight/rsrc.raz.block");
		System.out.println(toHexString(getHash(file,"MD5")));
		
		MD5FileInputStream fis = new  MD5FileInputStream(file);
		System.out.println(toHexString(getHash(fis,"MD5")));
		System.out.println(toHexString(fis.getDigest()));
		fis.close();

		InputStream newaa = new FileInputStream(file);
		System.out.println(newaa.read());
		
		MD5InputStream mfis = new MD5InputStream(new FileInputStream(file));
		System.out.println(toHexString(getHash(mfis,"MD5")));
		System.out.println(toHexString(mfis.getDigest()));
		

	}
}