package com.threerings.resource.util;

public class Hash {
	static final int[] cryptTable;
	static {
		cryptTable = new int[0xffff];
		int seed = 0x00100001;
		int index1;
		int index2;
		int i;
		for (index1 = 0; index1 < 0x100; index1++) {
			for (index2 = index1, i = 0; i < 5; i++, index2 += 0x100) {
				int temp1, temp2;
				seed = (seed * 125 + 3) % 0x2aaaab;
				temp1 = (seed & 0xffff) << 0x10;

				seed = (seed * 125 + 3) % 0x2aaaab;
				temp2 = (seed & 0xffff);

				cryptTable[index2] = temp1 | temp2;
			}
		}
	}
    public int hashA;
    public int hashB;

    public Hash(int code1, int code2) {
        this.hashA = code1;
        this.hashB = code2;
    }

    public Hash(String str) {
        this(hashString(str, 1), hashString(str, 2));
    }
    
    public Hash() {
    	
    }

    @Override
    public int hashCode() {
        return hashB;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o instanceof Hash) {
            Hash that = (Hash) o;
            return this.hashA == that.hashA && this.hashB == that.hashB;
        }
        return false;
    }
    
    public String toString(){
		return Integer.toString(hashA, 16)+"_"+Integer.toString(hashB, 16);
	}
    
    public static Hash toHash(String path) {
		return new Hash(hashString(path,1),hashString(path,2));
	}
    
    public static int hashString(String string, int hashType) {
		int seed1 = 0x7fed7fed;
		int seed2 = 0xeeeeeeee;

		string = string.toUpperCase();
		for (int i = 0; i < string.length(); i++) {
			int ch = string.charAt(i);
			seed1 = cryptTable[hashType * 0x100 + ch] ^ (seed1 + seed2);
			seed2 = ch + seed1 + seed2 + (seed2 << 5) + 3;
		}
		return seed1;
	}
}