package com.threerings.resource.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;


public class ByteArrayStoredInputStream extends InputStream {
	public static interface Closer {
		public void onClose(byte[] bts) throws IOException;
	}
	private ByteArrayOutputStream bos;
	private InputStream in;
	private Closer closer;
	private boolean closed;
	public ByteArrayStoredInputStream(InputStream in,Closer closer) throws IOException {
		init();
		this.in = in;
		this.closer = closer;
	}

	private void init() {
		bos = new ByteArrayOutputStream();
	}

	public int read() throws IOException {
		int b = in.read();
		if(b != -1){
			bos.write((byte)(b & 0xFF));
		}
		return b;
	}

	
	public int read(byte b[]) throws IOException {
		int r = in.read(b);
		if(r != -1){
			bos.write(b, 0, r);
		}
		return r;
    }
	
	public int read(byte b[], int off, int len) throws IOException {
		int r = in.read(b, off, len);
		if(r != -1){
			bos.write(b, off, r);
		}
		return r;
	}
	
	public void close () throws IOException {
		if(closed) {
			return;
		}
		
		if(in.available() > 0) {
			byte[] b = new byte[32];
			int size = 0;
			do {
				size = in.read(b);
				bos.write(b, 0, size);
			}while(in.available() > 0);
		}
		
		closer.onClose(bos.toByteArray());
		in.close();
		closed =true;
	}
}
