package com.threerings.resource;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

import java.util.HashMap;

/**
 * Allows other entities in an application to register URLStreamHandler
 * classes for protocols of their own making.
 */
public class AttachableURLFactory implements URLStreamHandlerFactory
{
	private static AttachableURLFactory INSTANCE = new AttachableURLFactory();
	
	static{
		URL.setURLStreamHandlerFactory(INSTANCE);
	}
	
    /**
     * Register a URL handler.
     *
     * @param protocol the protocol to register.
     * @param handlerClass a Class of type java.net.URLStreamHandler
     */
    public static void attachHandler (
        String protocol, URLStreamHandler handler)
    {
        _handlers.put(protocol.toLowerCase(), handler);
    }

    /**
     * Do not let others instantiate us.
     */
    private AttachableURLFactory ()
    {
    }

    // documentation inherited from interface URLStreamHandlerFactory
    public URLStreamHandler createURLStreamHandler (String protocol)
    {
    	return _handlers.get(protocol.toLowerCase());
    }

    /** A mapping of protocol name to handler classes. */
    protected static HashMap<String,URLStreamHandler> _handlers = new HashMap<String,URLStreamHandler>();
}
