/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tools;

import com.google.common.collect.Lists;
import com.samskivert.util.FileUtil;
import com.threerings.tools.xml.CompiledConfigParser;
import com.threerings.util.CompiledConfig;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class CompiledConfigTask
extends Task {
    protected File _configdef;
    protected File _target;
    protected File _dest;
    protected String _parser;
    protected ArrayList<FileSet> _filesets = Lists.newArrayList();

    public void setParser(String parser) {
        this._parser = parser;
    }

    public void setConfigdef(File configdef) {
        this._configdef = configdef;
    }

    public void setTarget(File target) {
        this._target = target;
    }

    public void setDest(File dest) {
        this._dest = dest;
    }

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void execute() throws BuildException {
        Object pobj = null;
        try {
            Class<?> pclass = Class.forName(this._parser);
            pobj = pclass.newInstance();
        }
        catch (Exception e) {
            throw new BuildException("Error instantiating config parser", (Throwable)e);
        }
        if (!(pobj instanceof CompiledConfigParser)) {
            throw new BuildException("Invalid parser class: " + this._parser);
        }
        CompiledConfigParser parser = pobj;
        if (this._configdef != null) {
            this.parse(parser, this._configdef, this._target == null ? this.getTarget(this._configdef) : this._target);
        }
        for (FileSet fs : this._filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] stringArray = ds.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File source = new File(fromDir, file);
                this.parse(parser, source, this.getTarget(source));
                ++n2;
            }
        }
    }

    protected File getTarget(File source) {
        if (this._dest == null) {
            return null;
        }
        String baseDir = this.getProject().getBaseDir().getPath();
        File target = new File(source.getPath().replace(baseDir, this._dest.getPath()));
        target = new File(FileUtil.resuffix((File)target, (String)".xml", (String)".dat"));
        return target;
    }

    protected void parse(CompiledConfigParser parser, File confdef, File target) throws BuildException {
        if (!confdef.exists()) {
            String errmsg = "Config definition file not found: " + confdef;
            throw new BuildException(errmsg);
        }
        if (target == null) {
            target = new File(FileUtil.resuffix((File)confdef, (String)".xml", (String)".dat"));
        }
        System.out.println("Compiling " + target + "...");
        Serializable config = null;
        try {
            config = parser.parseConfig(confdef);
        }
        catch (Exception e) {
            throw new BuildException("Failure parsing config definition", (Throwable)e);
        }
        File parent = target.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new BuildException("Failed to create parent directory '" + parent + "'.");
        }
        try {
            CompiledConfig.saveConfig((File)target, (Serializable)config);
        }
        catch (Exception e) {
            throw new BuildException("Failure writing serialized config", (Throwable)e);
        }
    }
}

