/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.bundle.tools;

import com.samskivert.util.HashIntMap;
import com.samskivert.util.StringUtil;
import com.threerings.cast.bundle.BundleUtil;
import com.threerings.resource.ResourceBundle;
import com.threerings.resource.file.FileResourceBundle;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class DumpBundle {
    public static void main(String[] args) {
        if (args.length < 1) {
            String usage = "Usage: DumpBundle bundle.jar [bundle.jar ...]";
            System.err.println(usage);
            System.exit(-1);
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            File file = new File(arg);
            try {
                FileResourceBundle bundle = new FileResourceBundle(file);
                HashMap actions = (HashMap)BundleUtil.loadObject((ResourceBundle)bundle, (String)"actions.dat", (boolean)false);
                DumpBundle.dumpTable("actions: ", actions);
                HashMap actionSets = (HashMap)BundleUtil.loadObject((ResourceBundle)bundle, (String)"action_sets.dat", (boolean)false);
                DumpBundle.dumpTable("actionSets: ", actionSets);
                HashMap classes = (HashMap)BundleUtil.loadObject((ResourceBundle)bundle, (String)"classes.dat", (boolean)false);
                DumpBundle.dumpTable("classes: ", classes);
                HashIntMap comps = (HashIntMap)BundleUtil.loadObject((ResourceBundle)bundle, (String)"components.dat", (boolean)false);
                DumpBundle.dumpTable("components: ", comps);
            }
            catch (Exception e) {
                System.err.println("Error dumping bundle [path=" + arg + ", error=" + e + "].");
                e.printStackTrace();
            }
            ++n2;
        }
    }

    protected static void dumpTable(String prefix, Map<?, ?> table) {
        if (table != null) {
            System.out.println(String.valueOf(prefix) + StringUtil.toString(table.entrySet().iterator()));
        }
    }
}

