/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools.cpp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.threerings.io.SimpleStreamableObject;
import com.threerings.io.Streamable;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.net.Message;
import com.threerings.presents.tools.GenTask;
import com.threerings.presents.tools.cpp.CPPField;
import com.threerings.presents.tools.cpp.CPPType;
import com.threerings.presents.tools.cpp.CPPUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;

public class GenCPPStreamableTask
extends GenTask {
    protected File _cpproot;
    protected Set<Class<?>> _toProcess = Sets.newHashSet();
    protected static final Set<Class<?>> NONSUPER = Sets.newHashSet();
    protected static final String HEADER_TMPL = "com/threerings/presents/tools/cpp/streamable_h.mustache";
    protected static final String CPP_TMPL = "com/threerings/presents/tools/cpp/streamable_cpp.mustache";

    static {
        NONSUPER.add(Message.class);
        NONSUPER.add(SimpleStreamableObject.class);
    }

    public Generate createGenerate() {
        return new Generate();
    }

    public void setCpproot(File asroot) {
        this._cpproot = asroot;
    }

    @Override
    public void execute() {
        for (Class<?> klass : this._toProcess) {
            this.processClass(null, klass);
        }
        super.execute();
    }

    @Override
    protected void processClass(File fn, Class<?> sclass) {
        try {
            this.processClass(sclass);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void processClass(Class<?> sclass) throws IOException {
        String outStream;
        String inStream;
        if (!Streamable.class.isAssignableFrom(sclass) || (sclass.getModifiers() & 0x200) != 0 || DSet.class.equals(sclass) || InvocationMarshaller.class.isAssignableFrom(sclass) && !InvocationMarshaller.class.equals(sclass)) {
            return;
        }
        System.err.println("Generating " + sclass.getName());
        boolean needSuper = Streamable.class.isAssignableFrom(sclass.getSuperclass()) && !NONSUPER.contains(sclass.getSuperclass());
        HashMap ctx = Maps.newHashMap();
        ctx.put("superclassStreamable", needSuper);
        ctx.put("name", sclass.getSimpleName());
        ctx.put("namespaces", CPPUtil.makeNamespaces(sclass));
        ctx.put("javaName", sclass.getName());
        ctx.put("namespace", CPPUtil.makeNamespace(sclass));
        TreeSet headerIncludes = Sets.newTreeSet();
        TreeSet implIncludes = Sets.newTreeSet();
        if (needSuper) {
            ctx.put("super", CPPUtil.makeCPPName(sclass.getSuperclass()));
            GenCPPStreamableTask.addInclude(sclass.getSuperclass(), headerIncludes);
        } else {
            ctx.put("super", "Streamable");
            headerIncludes.add("presents/Streamable.h");
        }
        ArrayList fields = Lists.newArrayList();
        ctx.put("fields", fields);
        Field[] fieldArray = sclass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mods = field.getModifiers();
            if (!Modifier.isStatic(mods) && !Modifier.isTransient(mods)) {
                CPPField cppField = new CPPField(field);
                fields.add(cppField);
                CPPType type = cppField.type;
                while (type != null) {
                    if ("JAVA_LIST_NAME()".equals(type.fixed)) {
                        implIncludes.add("presents/Streamer.h");
                    }
                    if (type.representationImport != null) {
                        headerIncludes.add(type.representationImport);
                    }
                    type = type.dependent;
                }
            }
            ++n2;
        }
        if (fields.isEmpty() && !needSuper) {
            inStream = "/*in*/";
            outStream = "/*out*/";
        } else {
            inStream = "in";
            outStream = "out";
        }
        ctx.put("inStreamArg", inStream);
        ctx.put("outStreamArg", outStream);
        ctx.put("includes", headerIncludes);
        this.writeTemplate(HEADER_TMPL, CPPUtil.makePath(this._cpproot, sclass, ".h"), ctx);
        ctx.put("includes", implIncludes);
        this.writeTemplate(CPP_TMPL, CPPUtil.makePath(this._cpproot, sclass, ".cpp"), ctx);
    }

    protected static void addInclude(Class<?> ftype, Set<String> includes) {
        includes.add(CPPUtil.makePath(ftype, ".h"));
    }

    public class Generate {
        public void setClass(String name) {
            GenCPPStreamableTask.this._toProcess.add(GenCPPStreamableTask.this.loadClass(name));
        }
    }
}

