/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools.cpp;

import com.threerings.io.Streamable;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.tools.cpp.CPPUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CPPType {
    public static final String JAVA_LIST_FIXED = "JAVA_LIST_NAME()";
    public final String type;
    public final String interpreter;
    public final String cast;
    public final String fixed;
    public final CPPType dependent;
    public final String representationImport;
    public final Class<?> rawType;
    public final boolean primitive;
    protected static final Pattern TYPE_EXTRACT = Pattern.compile("Shared<(.*)>");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CPPType(Type javaType) {
        this.rawType = javaType instanceof ParameterizedType ? (Class)((ParameterizedType)javaType).getRawType() : (javaType instanceof TypeVariable ? (Class)((TypeVariable)javaType).getBounds()[0] : (Class)javaType);
        this.fixed = this.rawType.equals(List.class) ? JAVA_LIST_FIXED : null;
        if (this.rawType.isArray()) {
            Class<?> componentType = this.rawType.getComponentType();
            this.dependent = new CPPType(componentType);
            this.type = "Shared< std::vector< " + this.dependent.type + " > >";
            this.interpreter = componentType.equals(Object.class) || componentType.isPrimitive() ? "Field" : "Object";
            this.representationImport = null;
        } else {
            this.type = CPPUtil.getCPPType(javaType);
            this.interpreter = this.getCPPInterpreter(this.rawType);
            if (javaType instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)javaType).getActualTypeArguments();
                if (this.rawType.equals(Comparable.class)) {
                    this.dependent = new CPPType((Type)((Object)Streamable.class));
                    this.representationImport = "presents/Streamable.h";
                } else if (this.rawType == List.class) {
                    Class param = typeArguments[0] instanceof ParameterizedType ? (Class)((ParameterizedType)typeArguments[0]).getRawType() : (Class)typeArguments[0];
                    if (!Streamable.class.isAssignableFrom(param)) {
                        throw new IllegalArgumentException("Lists may only contain Streamables in C++, not '" + typeArguments[0] + "'");
                    }
                    this.dependent = new CPPType(param);
                    this.representationImport = null;
                } else {
                    if (!this.rawType.equals(DSet.class)) throw new IllegalArgumentException("Don't know how to handle " + this.rawType);
                    this.dependent = null;
                    this.representationImport = CPPUtil.makePath(this.rawType, ".h");
                }
            } else if (javaType instanceof TypeVariable || javaType.equals(DSet.Entry.class)) {
                this.dependent = new CPPType((Type)((Object)Streamable.class));
                this.representationImport = "presents/Streamable.h";
            } else {
                this.representationImport = !Streamable.class.equals(this.rawType) && Streamable.class.isAssignableFrom(this.rawType) ? CPPUtil.makePath(this.rawType, ".h") : null;
                this.dependent = null;
            }
        }
        this.primitive = this.rawType.isPrimitive();
        Matcher m = TYPE_EXTRACT.matcher(this.type);
        this.cast = m.matches() ? "boost::static_pointer_cast<" + m.group(1) + ">" : this.type;
    }

    protected String getCPPInterpreter(Class<?> ftype) {
        if (ftype.equals(String.class) || ftype.equals(List.class)) {
            return "Field";
        }
        if (ftype.equals(Boolean.TYPE)) {
            return "Boolean";
        }
        if (ftype.equals(Byte.TYPE)) {
            return "Byte";
        }
        if (ftype.equals(Short.TYPE)) {
            return "Short";
        }
        if (ftype.equals(Integer.TYPE)) {
            return "Int";
        }
        if (ftype.equals(Long.TYPE)) {
            return "Long";
        }
        if (ftype.equals(Float.TYPE)) {
            return "Float";
        }
        if (ftype.equals(Double.TYPE)) {
            return "Double";
        }
        return "Object";
    }

    public String getCastFromStreamable(String name) {
        if (this.primitive) {
            return "boost::static_pointer_cast<presents::box::Boxed" + this.interpreter + ">(" + name + ")->value";
        }
        return String.valueOf(this.cast) + "(" + name + ")";
    }

    public String getAsStreamable(String name) {
        if (this.primitive) {
            return "presents::box::Boxed" + this.interpreter + "::createShared(" + name + ")";
        }
        return name;
    }

    public String getWithoutShared() {
        Matcher m = TYPE_EXTRACT.matcher(this.type);
        return m.matches() ? m.group(1) : this.type;
    }
}

