/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools.cpp;

import com.google.common.collect.Lists;
import com.threerings.presents.tools.InvocationTask;
import com.threerings.presents.tools.cpp.CPPType;
import com.threerings.presents.tools.cpp.CPPUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class CPPArgBuilder {
    public String getArguments(InvocationTask.ServiceMethod meth) {
        return this.getArguments(meth, "");
    }

    public String getArguments(InvocationTask.ServiceMethod meth, String prefix) {
        StringBuilder buf = new StringBuilder(prefix);
        Type[] ptypes = meth.method.getGenericParameterTypes();
        int ii = 0;
        while (ii < ptypes.length) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(CPPUtil.getCPPType(ptypes[ii])).append(" arg").append(ii + 1);
            ++ii;
        }
        return buf.toString();
    }

    public List<String> getArgumentNames(InvocationTask.ServiceMethod meth) {
        Type[] ptypes = meth.method.getGenericParameterTypes();
        ArrayList args = Lists.newArrayListWithCapacity((int)ptypes.length);
        int ii = 0;
        while (ii < ptypes.length) {
            args.add("arg" + (ii + 1));
            ++ii;
        }
        return args;
    }

    public String getArgumentsFromVector(InvocationTask.ServiceMethod meth) {
        StringBuilder buf = new StringBuilder();
        Type[] ptypes = meth.method.getGenericParameterTypes();
        int ii = 0;
        while (ii < ptypes.length) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            CPPType type = new CPPType(ptypes[ii]);
            buf.append(type.getCastFromStreamable("args[" + ii + "]"));
            ++ii;
        }
        return buf.toString();
    }

    public List<String> getServiceArguments(InvocationTask.ServiceMethod meth) {
        Type[] ptypes = meth.method.getGenericParameterTypes();
        ArrayList args = Lists.newArrayListWithCapacity((int)ptypes.length);
        int ii = 0;
        while (ii < ptypes.length) {
            args.add(new CPPType(ptypes[ii]).getAsStreamable("arg" + (ii + 1)));
            ++ii;
        }
        return args;
    }
}

