/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.samskivert.util.Logger;
import com.samskivert.util.StringUtil;
import com.threerings.presents.annotation.TransportHint;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.net.Transport;
import com.threerings.presents.tools.GenTask;
import com.threerings.presents.tools.GenUtil;
import com.threerings.presents.tools.ImportSet;
import com.threerings.presents.util.Method;
import java.io.File;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class InvocationTask
extends GenTask {
    protected Class<?> _ilistener;
    protected Class<?> _iclient;

    public ServiceMethod createAndGatherImports(java.lang.reflect.Method method, ImportSet imports) {
        ServiceMethod sm = new ServiceMethod(method);
        sm.gatherImports(imports);
        return sm;
    }

    @Override
    public void execute() {
        this._ilistener = this.loadClass(InvocationService.InvocationListener.class.getName());
        this._iclient = this.loadClass(Client.class.getName());
        super.execute();
    }

    protected static <T> void checkedAdd(List<T> list, T value) {
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    protected static String replacePath(String source, String oldstr, String newstr) {
        return source.replace(oldstr.replace('/', File.separatorChar), newstr.replace('/', File.separatorChar));
    }

    public class ListenerArgument {
        public Class<?> listener;
        protected int _index;

        public ListenerArgument(int index, Class<?> listener) {
            this.listener = listener;
            this._index = index;
        }

        public String getMarshaller() {
            String name = GenUtil.simpleName(this.listener);
            if (name.equals("InvocationService.InvocationListener")) {
                return "ListenerMarshaller";
            }
            name = name.replace("Service", "Marshaller");
            return name.replace("Listener", "Marshaller");
        }

        public String getActionScriptMarshaller() {
            String name = this.listener.getName();
            if (name.endsWith("InvocationService$InvocationListener")) {
                return "InvocationMarshaller_ListenerMarshaller";
            }
            return this.getMarshaller().replace('.', '_');
        }

        public int getIndex() {
            return this._index + 1;
        }
    }

    public class ServiceMethod
    implements Comparable<ServiceMethod> {
        public java.lang.reflect.Method method;
        public List<ListenerArgument> listenerArgs = Lists.newArrayList();
        public int methodId;

        public ServiceMethod(java.lang.reflect.Method method) {
            this.method = method;
            Method annotation = method.getAnnotation(Method.class);
            if (annotation != null) {
                this.methodId = annotation.index();
                System.out.println(String.valueOf(method.getName()) + " MethodId=" + this.methodId);
            }
            Class<?>[] args = method.getParameterTypes();
            int ii = 0;
            while (ii < args.length) {
                Class<?> arg = args[ii];
                while (arg.isArray()) {
                    arg = arg.getComponentType();
                }
                if (InvocationTask.this._ilistener.isAssignableFrom(arg)) {
                    this.listenerArgs.add(new ListenerArgument(ii, arg));
                }
                ++ii;
            }
        }

        public void gatherImports(ImportSet imports) {
            Type[] typeArray = this.method.getGenericParameterTypes();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                this.addImportsForType(type, imports);
                ++n2;
            }
            if (!StringUtil.isBlank((String)this.getTransport())) {
                imports.add(Transport.class);
            }
        }

        public String getCode() {
            return StringUtil.unStudlyName((String)this.method.getName()).toUpperCase();
        }

        public String getSenderMethodName() {
            String mname = this.method.getName();
            if (mname.startsWith("received")) {
                return "send" + mname.substring("received".length());
            }
            return mname;
        }

        public String typeParams() {
            ArrayList params = Lists.newArrayList();
            Type[] typeArray = this.method.getGenericParameterTypes();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                this.collectTypeParams(type, params);
                ++n2;
            }
            return params.isEmpty() ? "" : StringUtil.toString((Object)params, (String)"<", (String)"> ");
        }

        public String getArgList() {
            StringBuilder buf = new StringBuilder();
            Type[] ptypes = this.method.getGenericParameterTypes();
            int ii = 0;
            while (ii < ptypes.length) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                String simpleName = GenUtil.simpleName((Type)ptypes[ii]);
                if (this.method.isVarArgs() && ii == ptypes.length - 1) {
                    buf.append(simpleName.substring(0, simpleName.length() - 2)).append("...");
                } else {
                    buf.append(simpleName);
                }
                buf.append(" arg").append(ii + 1);
                ++ii;
            }
            return buf.toString();
        }

        public String getASArgList() {
            StringBuilder buf = new StringBuilder();
            Class<?>[] args = this.method.getParameterTypes();
            int ii = 0;
            while (ii < args.length) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append("arg").append(ii + 1).append(" :");
                buf.append(GenUtil.simpleASName(args[ii]));
                ++ii;
            }
            return buf.toString();
        }

        public String getASInvokeArgList() {
            StringBuilder buf = new StringBuilder();
            Class<?>[] args = this.method.getParameterTypes();
            int ii = 0;
            while (ii < args.length) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append("arg").append(ii + 1);
                ++ii;
            }
            return buf.toString();
        }

        public String getWrappedArgList() {
            StringBuilder buf = new StringBuilder();
            Class<?>[] args = this.method.getParameterTypes();
            int ii = 0;
            while (ii < args.length) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(this.boxArgument(args[ii], ii + 1));
                ++ii;
            }
            return buf.toString();
        }

        public void gatherASWrappedArgListImports(ImportSet set) {
            Class<?>[] args = this.method.getParameterTypes();
            int ii = 0;
            while (ii < args.length) {
                set.addAll(GenUtil.getASBoxImports(args[ii]));
                ++ii;
            }
        }

        public String getASWrappedArgList() {
            StringBuilder buf = new StringBuilder();
            Class<?>[] args = this.method.getParameterTypes();
            int ii = 0;
            while (ii < args.length) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                String index = String.valueOf(ii + 1);
                String arg = InvocationTask.this._ilistener.isAssignableFrom(args[ii]) ? GenUtil.boxASArgument(args[ii], "listener" + index) : GenUtil.boxASArgument(args[ii], "arg" + index);
                buf.append(arg);
                ++ii;
            }
            return buf.toString();
        }

        public boolean hasArgs() {
            return this.method.getParameterTypes().length > 0;
        }

        public boolean hasParameterizedArgs() {
            return Iterables.any(Arrays.asList(this.method.getGenericParameterTypes()), (Predicate)new Predicate<Type>(){

                public boolean apply(Type type) {
                    return type instanceof ParameterizedType;
                }
            });
        }

        public String getUnwrappedArgListAsListeners() {
            return this.getUnwrappedArgList(true);
        }

        public String getUnwrappedArgList() {
            return this.getUnwrappedArgList(false);
        }

        public String getUnwrappedArgList(boolean listenerMode) {
            StringBuilder buf = new StringBuilder();
            Type[] ptypes = this.method.getGenericParameterTypes();
            int ii = 0;
            while (ii < ptypes.length) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(this.unboxArgument(ptypes[ii], ii, listenerMode));
                ++ii;
            }
            return buf.toString();
        }

        public String getASUnwrappedArgListAsListeners() {
            return this.getASUnwrappedArgList(true);
        }

        public String getASUnwrappedArgList() {
            return this.getASUnwrappedArgList(false);
        }

        public String getASUnwrappedArgList(boolean listenerMode) {
            StringBuilder buf = new StringBuilder();
            Class<?>[] args = this.method.getParameterTypes();
            int ii = 0;
            while (ii < args.length) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                int argidx = ii;
                String arg = listenerMode && InvocationTask.this._ilistener.isAssignableFrom(args[ii]) ? "listener" + argidx : GenUtil.unboxASArgument(args[ii], "args[" + argidx + "]");
                buf.append(arg);
                ++ii;
            }
            return buf.toString();
        }

        public String getTransport() {
            TransportHint hint = this.method.getAnnotation(TransportHint.class);
            if (hint == null) {
                hint = this.method.getDeclaringClass().getAnnotation(TransportHint.class);
            }
            if (hint == null) {
                return "";
            }
            return ", Transport.getInstance(Transport.Type." + hint.type().name() + ", " + hint.channel() + ")";
        }

        @Override
        public int compareTo(ServiceMethod other) {
            int idxDeta = this.methodId - other.methodId;
            return idxDeta < 0 ? -1 : (idxDeta > 0 ? idxDeta : this.getCode().compareTo(other.getCode()));
        }

        public boolean equals(Object other) {
            return other instanceof ServiceMethod && this.compareTo((ServiceMethod)other) == 0;
        }

        public int hashCode() {
            return this.getCode().hashCode();
        }

        protected void addImportsForType(Type type, ImportSet imports) {
            if (type instanceof Class) {
                imports.add((Class)type);
            } else if (type instanceof ParameterizedType) {
                imports.add((Class)((ParameterizedType)type).getRawType());
                Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type param = typeArray[n2];
                    this.addImportsForType(param, imports);
                    ++n2;
                }
            } else if (type instanceof WildcardType) {
                Type[] typeArray = ((WildcardType)type).getUpperBounds();
                int n = typeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Type upper = typeArray[n3];
                    this.addImportsForType(upper, imports);
                    ++n3;
                }
                typeArray = ((WildcardType)type).getLowerBounds();
                n = typeArray.length;
                n3 = 0;
                while (n3 < n) {
                    Type lower = typeArray[n3];
                    this.addImportsForType(lower, imports);
                    ++n3;
                }
            } else if (type instanceof GenericArrayType) {
                this.addImportsForType(((GenericArrayType)type).getGenericComponentType(), imports);
            } else if (!(type instanceof TypeVariable)) {
                System.err.println(Logger.format((Object)"Unhandled Type in adding imports for a service", (Object[])new Object[]{"type", type, "typeClass", type.getClass()}));
            }
        }

        protected void collectTypeParams(Type type, List<String> params) {
            block7: {
                block6: {
                    if (!(type instanceof TypeVariable)) break block6;
                    String tvar = ((TypeVariable)type).getName();
                    if (params.contains(tvar)) break block7;
                    params.add(tvar);
                    break block7;
                }
                if (type instanceof ParameterizedType) {
                    Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                    int n = typeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Type pt = typeArray[n2];
                        this.collectTypeParams(pt, params);
                        ++n2;
                    }
                } else if (type instanceof WildcardType) {
                    Type[] typeArray = ((WildcardType)type).getLowerBounds();
                    int n = typeArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Type lb = typeArray[n3];
                        this.collectTypeParams(lb, params);
                        ++n3;
                    }
                    typeArray = ((WildcardType)type).getUpperBounds();
                    n = typeArray.length;
                    n3 = 0;
                    while (n3 < n) {
                        Type ub = typeArray[n3];
                        this.collectTypeParams(ub, params);
                        ++n3;
                    }
                }
            }
        }

        protected String boxArgument(Class<?> clazz, int index) {
            if (InvocationTask.this._ilistener.isAssignableFrom(clazz)) {
                return GenUtil.boxArgument(clazz, "listener" + index);
            }
            return GenUtil.boxArgument(clazz, "arg" + index);
        }

        protected String unboxArgument(Type type, int index, boolean listenerMode) {
            if (listenerMode && type instanceof Class && InvocationTask.this._ilistener.isAssignableFrom((Class)type)) {
                return "listener" + index;
            }
            return GenUtil.unboxArgument(type, "args[" + index + "]");
        }
    }
}

