/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.samskivert.util.StringUtil;
import com.threerings.presents.tools.ImportSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenUtil
extends com.samskivert.util.GenUtil {
    public static final Pattern PACKAGE_PATTERN = Pattern.compile("^\\s*package\\s+(\\S+)\\W");
    public static final Pattern NAME_PATTERN = Pattern.compile("^\\s*public\\s+(?:(?:abstract|final)\\s+)*(@?interface|class|enum)\\s+([\\w$]+)");

    public static String simpleASName(Class<?> clazz) {
        if (clazz.isArray()) {
            Class<?> compoType = clazz.getComponentType();
            if (Byte.TYPE.equals(compoType)) {
                return "ByteArray";
            }
            if (Object.class.equals(compoType)) {
                return "Array";
            }
            return "TypedArray /* of " + compoType + " */";
        }
        if (clazz == Boolean.TYPE) {
            return "Boolean";
        }
        if (clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE) {
            return "int";
        }
        if (clazz == Long.TYPE) {
            return "Long";
        }
        if (clazz == Float.TYPE || clazz == Double.TYPE) {
            return "Number";
        }
        String cname = clazz.getName();
        Package pkg = clazz.getPackage();
        int offset = pkg == null ? 0 : pkg.getName().length() + 1;
        String name = cname.substring(offset);
        return name.replace('$', '_');
    }

    public static String boxArgument(Class<?> clazz, String name) {
        if (clazz == Boolean.TYPE) {
            return "Boolean.valueOf(" + name + ")";
        }
        if (clazz == Byte.TYPE) {
            return "Byte.valueOf(" + name + ")";
        }
        if (clazz == Character.TYPE) {
            return "Character.valueOf(" + name + ")";
        }
        if (clazz == Short.TYPE) {
            return "Short.valueOf(" + name + ")";
        }
        if (clazz == Integer.TYPE) {
            return "Integer.valueOf(" + name + ")";
        }
        if (clazz == Long.TYPE) {
            return "Long.valueOf(" + name + ")";
        }
        if (clazz == Float.TYPE) {
            return "Float.valueOf(" + name + ")";
        }
        if (clazz == Double.TYPE) {
            return "Double.valueOf(" + name + ")";
        }
        return name;
    }

    public static String unboxArgument(Type type, String name) {
        if (Boolean.TYPE.equals(type)) {
            return "((Boolean)" + name + ").booleanValue()";
        }
        if (Byte.TYPE.equals(type)) {
            return "((Byte)" + name + ").byteValue()";
        }
        if (Character.TYPE.equals(type)) {
            return "((Character)" + name + ").charValue()";
        }
        if (Short.TYPE.equals(type)) {
            return "((Short)" + name + ").shortValue()";
        }
        if (Integer.TYPE.equals(type)) {
            return "((Integer)" + name + ").intValue()";
        }
        if (Long.TYPE.equals(type)) {
            return "((Long)" + name + ").longValue()";
        }
        if (Float.TYPE.equals(type)) {
            return "((Float)" + name + ").floatValue()";
        }
        if (Double.TYPE.equals(type)) {
            return "((Double)" + name + ").doubleValue()";
        }
        if (Object.class.equals((Object)type)) {
            return name;
        }
        if (type instanceof Class) {
            return "(" + GenUtil.simpleName((Type)type) + ")" + name;
        }
        return "this.<" + GenUtil.simpleName((Type)type) + ">cast(" + name + ")";
    }

    public static String boxASArgument(Class<?> clazz, String name) {
        return GenUtil.boxASArgumentAndGatherImports(clazz, name, new ImportSet());
    }

    public static ImportSet getASBoxImports(Class<?> clazz) {
        ImportSet imports = new ImportSet();
        GenUtil.boxASArgumentAndGatherImports(clazz, "foo", imports);
        return imports;
    }

    public static String unboxASArgument(Class<?> clazz, String name) {
        if (clazz == Boolean.TYPE) {
            return "(" + name + " as Boolean)";
        }
        if (clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE) {
            return "(" + name + " as int)";
        }
        if (clazz == Long.TYPE) {
            return "(" + name + " as Long)";
        }
        if (clazz == Float.TYPE || clazz == Double.TYPE) {
            return "(" + name + " as Number)";
        }
        return "(" + name + " as " + GenUtil.simpleASName(clazz) + ")";
    }

    public static String cloneArgument(Class<?> dsclazz, Field field, String name) {
        Class<?> clazz = field.getType();
        if (clazz.isArray() || dsclazz.equals(clazz)) {
            return "(" + name + " == null) ? null : " + name + ".clone()";
        }
        if (dsclazz.isAssignableFrom(clazz)) {
            return "(" + name + " == null) ? null : " + "(" + GenUtil.simpleName((Field)field) + ")" + name + ".clone()";
        }
        return name;
    }

    public static String readClassName(File source) throws IOException {
        String line;
        String pkgname = null;
        String name = null;
        BufferedReader bin = new BufferedReader(new FileReader(source));
        while ((line = bin.readLine()) != null) {
            Matcher nm;
            Matcher pm = PACKAGE_PATTERN.matcher(line);
            if (pm.find()) {
                pkgname = pm.group(1);
            }
            if (!(nm = NAME_PATTERN.matcher(line)).find()) continue;
            name = nm.group(2);
            break;
        }
        bin.close();
        if (name == null) {
            throw new IOException("Unable to locate class or interface name in " + source + ".");
        }
        if (pkgname != null) {
            name = String.valueOf(pkgname) + "." + name;
        }
        return name;
    }

    public static String getGeneratedAnnotation(Class<?> clazz, int indent, boolean includeDate, String ... comments) {
        int LINE_LENGTH = 100;
        String comm = StringUtil.join((Object[])comments, (String)" ");
        boolean hasComment = !StringUtil.isBlank((String)comm);
        String anno = "@Generated(value={\"" + clazz.getName() + "\"}";
        if (includeDate) {
            anno = String.valueOf(anno) + ",";
            String date = " date=\"" + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(new Date()) + "\"";
            if (hasComment || anno.length() + date.length() + 1 + indent > 100) {
                date = "\n" + StringUtil.fill((char)' ', (int)(indent + 10)) + date;
            }
            anno = String.valueOf(anno) + date;
        }
        if (hasComment) {
            anno = String.valueOf(anno) + ",\n" + StringUtil.fill((char)' ', (int)(indent + 11)) + "comments=\"" + comm + "\"";
        }
        anno = String.valueOf(anno) + ")";
        return anno;
    }

    protected static String boxASArgumentAndGatherImports(Class<?> clazz, String name, ImportSet imports) {
        if (clazz == Boolean.TYPE) {
            imports.add(Boolean.class);
            return "langBoolean.valueOf(" + name + ")";
        }
        if (clazz == Byte.TYPE) {
            imports.add(Byte.class);
            return "Byte.valueOf(" + name + ")";
        }
        if (clazz == Character.TYPE) {
            imports.add(Character.class);
            return "Character.valueOf(" + name + ")";
        }
        if (clazz == Short.TYPE) {
            imports.add(Short.class);
            return "Short.valueOf(" + name + ")";
        }
        if (clazz == Integer.TYPE) {
            imports.add(Integer.class);
            return "Integer.valueOf(" + name + ")";
        }
        if (clazz == Long.TYPE) {
            imports.add(Long.class);
            return name;
        }
        if (clazz == Float.TYPE) {
            imports.add(Float.class);
            return "Float.valueOf(" + name + ")";
        }
        if (clazz == Double.TYPE) {
            imports.add(Double.class);
            return "Double.valueOf(" + name + ")";
        }
        imports.add(name);
        return name;
    }
}

