/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.util.ComparableArrayList;
import com.samskivert.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportSet {
    protected HashSet<String> _imports = Sets.newHashSet();
    protected List<String> _pushed = Lists.newArrayList();
    protected static Pattern _splitter = Pattern.compile("\\*");
    protected static List<String> IMPORT_GROUPS = Lists.newArrayList((Object[])new String[]{"flash", "fl", "java", "javax", "android", "", "com.samskivert", "com.samskivert.swing", "com.samskivert.servlet", "com.samskivert.velocity", "com.samskivert.jdbc", "com.samskivert.depot", "com.threerings.io", "com.threerings.no", "com.threerings.util", "com.threerings.presents", "com.threerings.crowd", "com.threerings.admin", "com.threerings.bureau", "com.threering.tudey", "com.threerings.display", "com.threerings.geom", "com.threerings.media", "com.threerings.text", "com.threerings.ui", "com.threerings.flashbang", "com.threerings.samsara", "com.threerings.cast", "com.threerings.resource", "com.threerings.miso", "com.threerings.jme", "com.threerings.openal", "com.threerings.tools", "com.threerings.lembas", "com.threerings.parlor", "com.threerings.puzzle", "com.threerings.whirled", "com.threerings.micasa", "com.threerings.stage", "com.threerings.stats", "com.threerings.orth", "com.threerings", "com.threerings.piracy", "com.threerings.ppa", "com.threerings.yohoho", "com.threerings.who", "com.threerings.projectx"});

    public void add(Class<?> clazz) {
        this._imports.add(clazz.getName());
    }

    public void add(String name) {
        if (name != null) {
            this._imports.add(name);
        }
    }

    public void addAll(ImportSet other) {
        this._imports.addAll(other._imports);
    }

    public void addMunged(Class<?> clazz, String ... replace) {
        String name = clazz.getName();
        for (int ii = 0; ii < replace.length; ii += 2) {
            name = name.replace(replace[ii], replace[ii + 1]);
        }
        this._imports.add(name);
    }

    public ImportSet clone() {
        ImportSet newset = new ImportSet();
        newset.addAll(this);
        return newset;
    }

    public void removeGlobals() {
        Iterator<String> i = this._imports.iterator();
        while (i.hasNext()) {
            String name = i.next();
            if (name.indexOf(46) == -1) {
                i.remove();
                continue;
            }
            if (!name.startsWith("java.lang")) continue;
            i.remove();
        }
    }

    public int removeArrays() {
        return this.removeAll("[*");
    }

    public void removeSamePackage(String pkg) {
        Iterator<String> i = this._imports.iterator();
        while (i.hasNext()) {
            String name = i.next();
            if (!name.startsWith(pkg) || name.indexOf(46, pkg.length() + 1) != -1) continue;
            i.remove();
        }
    }

    public void swapInnerClassesForParents() {
        ImportSet declarers = new ImportSet();
        Iterator<String> i = this._imports.iterator();
        while (i.hasNext()) {
            String name = i.next();
            int dollar = name.indexOf(36);
            if (dollar < 0) continue;
            i.remove();
            declarers.add(name.substring(0, dollar));
        }
        this.addAll(declarers);
    }

    public void translateInnerClasses() {
        ImportSet inner = new ImportSet();
        Iterator<String> i = this._imports.iterator();
        while (i.hasNext()) {
            String name = i.next();
            int dollar = name.indexOf(36);
            if (dollar < 0) continue;
            i.remove();
            inner.add(name.replace('$', '_'));
        }
        this.addAll(inner);
    }

    public void translateClassArrays() {
        ImportSet arrayTypes = new ImportSet();
        for (String name : this._imports) {
            int bracket = name.lastIndexOf(91);
            if (bracket == -1 || name.charAt(bracket + 1) != 'L') continue;
            arrayTypes.add(name.substring(bracket + 2, name.length() - 1));
        }
        this.addAll(arrayTypes);
    }

    public void pushOut(String pattern) {
        Pattern pat = ImportSet.makePattern(pattern);
        Iterator<String> i = this._imports.iterator();
        while (i.hasNext()) {
            String imp = i.next();
            if (!pat.matcher(imp).matches()) continue;
            i.remove();
            this._pushed.add(imp);
            return;
        }
        this._pushed.add(null);
    }

    public void popIn() {
        String front = this._pushed.remove(this._pushed.size() - 1);
        if (front != null) {
            this._imports.add(front);
        }
    }

    public void remove(String name) {
        this._imports.remove(name);
    }

    public void remove(Class<?> clazz) {
        this._imports.remove(clazz.getName());
    }

    public void replace(String ... replace) {
        HashSet toAdd = Sets.newHashSet();
        Iterator<String> i = this._imports.iterator();
        block0: while (i.hasNext()) {
            String name = i.next();
            for (int j = 0; j < replace.length; j += 2) {
                if (!name.equals(replace[j])) continue;
                toAdd.add(replace[j + 1]);
                i.remove();
                continue block0;
            }
        }
        this._imports.addAll(toAdd);
    }

    public void replace(Class<?> pattern, String replacement) {
        this.replace(pattern.getName(), replacement);
    }

    public int removeAll(String pattern) {
        Pattern pat = ImportSet.makePattern(pattern);
        int removed = 0;
        Iterator<String> i = this._imports.iterator();
        while (i.hasNext()) {
            String name = i.next();
            if (!pat.matcher(name).matches()) continue;
            i.remove();
            ++removed;
        }
        return removed;
    }

    public void duplicateAndMunge(String pattern, String ... replace) {
        Pattern pat = ImportSet.makePattern(pattern);
        HashSet toMunge = Sets.newHashSet();
        for (String name : this._imports) {
            if (!pat.matcher(name).matches()) continue;
            toMunge.add(name);
        }
        Iterator<String> iterator = toMunge.iterator();
        while (iterator.hasNext()) {
            String name;
            String newname = name = iterator.next();
            for (int ii = 0; ii < replace.length; ii += 2) {
                newname = newname.replace(replace[ii], replace[ii + 1]);
            }
            this._imports.add(newname);
        }
    }

    public List<List<String>> toGroups() {
        ArrayList list = Lists.newArrayList(this._imports);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String class1, String class2) {
                return ComparisonChain.start().compare(ImportSet.findImportGroup(class1), ImportSet.findImportGroup(class2)).compare((Comparable)((Object)class1), (Comparable)((Object)class2)).result();
            }
        });
        ArrayList result = Lists.newArrayList();
        List current = null;
        int lastGroup = -2;
        for (String imp : list) {
            int group = ImportSet.findImportGroup(imp);
            if (group != lastGroup) {
                if (current == null || !current.isEmpty()) {
                    current = Lists.newArrayList();
                    result.add(current);
                }
                lastGroup = group;
            }
            current.add(imp);
        }
        return result;
    }

    public List<String> toList() {
        ComparableArrayList list = new ComparableArrayList();
        list.addAll(this._imports);
        list.sort();
        return list;
    }

    public String toString() {
        return StringUtil.toString(this._imports);
    }

    protected static Pattern makePattern(String input) {
        StringBuilder pattern = new StringBuilder(94);
        while (true) {
            String[] parts = _splitter.split(input, 2);
            pattern.append(Pattern.quote(parts[0]));
            if (parts.length == 1) break;
            int length = parts[0].length();
            String wildcard = input.substring(length, length + 1);
            if (wildcard.equals("*")) {
                pattern.append(".*");
            } else {
                System.err.println("Bad wildcard " + wildcard);
            }
            input = parts[1];
        }
        pattern.append("$");
        return Pattern.compile(pattern.toString());
    }

    protected static int findImportGroup(String imp) {
        String longest = null;
        for (String prefix : IMPORT_GROUPS) {
            if (!imp.startsWith(prefix) || longest != null && prefix.length() <= longest.length()) continue;
            longest = prefix;
        }
        return IMPORT_GROUPS.indexOf(longest);
    }
}

