/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.collect.Lists;
import com.samskivert.util.StringUtil;
import com.threerings.presents.annotation.Transient;
import com.threerings.presents.annotation.TransportHint;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.tools.GenTask;
import com.threerings.presents.tools.GenUtil;
import com.threerings.presents.tools.SourceFile;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenDObjectTask
extends GenTask {
    protected Class<?> _doclass;
    protected Class<?> _dsclass;
    protected Class<?> _olclass;
    protected static final String BASE_TMPL = "com/threerings/presents/tools/dobject_";
    protected static final String NAME_TMPL = "com/threerings/presents/tools/dobject_name.tmpl";

    @Override
    public void execute() {
        this._doclass = this.loadClass(DObject.class.getName());
        this._dsclass = this.loadClass(DSet.class.getName());
        this._olclass = this.loadClass(OidList.class.getName());
        super.execute();
    }

    @Override
    public void processClass(File source, Class<?> oclass) throws Exception {
        Field[] fields;
        if (!this._doclass.isAssignableFrom(oclass) || this._doclass.equals(oclass)) {
            return;
        }
        ArrayList flist = Lists.newArrayList();
        for (Field f : fields = oclass.getDeclaredFields()) {
            int mods = f.getModifiers();
            Transient hint = f.getAnnotation(Transient.class);
            if (hint == null) {
                hint = f.getDeclaringClass().getAnnotation(Transient.class);
            }
            if (!Modifier.isPublic(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods) || hint != null) continue;
            flist.add(f);
        }
        SourceFile sfile = new SourceFile();
        sfile.readFrom(source);
        StringBuilder fsection = new StringBuilder();
        StringBuilder msection = new StringBuilder();
        for (int ii = 0; ii < flist.size(); ++ii) {
            Field f = (Field)flist.get(ii);
            Class<?> ftype = f.getType();
            String fname = f.getName();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("field", fname);
            data.put("generated", GenUtil.getGeneratedAnnotation(((Object)((Object)this)).getClass(), 4, false, new String[0]));
            data.put("type", GenUtil.simpleName((Field)f));
            data.put("wrapfield", GenUtil.boxArgument(ftype, "value"));
            data.put("wrapofield", GenUtil.boxArgument(ftype, "ovalue"));
            data.put("clonefield", GenUtil.cloneArgument(this._dsclass, f, "value"));
            data.put("capfield", StringUtil.unStudlyName((String)fname).toUpperCase());
            data.put("upfield", StringUtil.capitalize((String)fname));
            TransportHint hint = f.getAnnotation(TransportHint.class);
            if (hint == null) {
                hint = f.getDeclaringClass().getAnnotation(TransportHint.class);
            }
            String transport = hint == null ? "" : ",\n            com.threerings.presents.net.Transport.getInstance(\n                com.threerings.presents.net.Transport.Type." + hint.type().name() + ", " + hint.channel() + ")";
            data.put("transport", transport);
            boolean array = ftype.isArray();
            data.put("have_elem", array);
            if (array) {
                Class<?> etype = ftype.getComponentType();
                data.put("elemtype", GenUtil.simpleName(etype));
                data.put("wrapelem", GenUtil.boxArgument(etype, "value"));
                data.put("wrapoelem", GenUtil.boxArgument(etype, "ovalue"));
            }
            if (this._dsclass.isAssignableFrom(ftype)) {
                Type t = f.getGenericType();
                while (t instanceof Class) {
                    t = ((Class)t).getGenericSuperclass();
                }
                if (t instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)t;
                    if (pt.getActualTypeArguments().length > 0) {
                        data.put("etype", GenUtil.simpleName((Type)pt.getActualTypeArguments()[0]));
                    }
                } else {
                    data.put("etype", "DSet.Entry");
                }
            }
            String tname = "field.tmpl";
            if (this._dsclass.isAssignableFrom(ftype)) {
                tname = "set.tmpl";
            } else if (this._olclass.isAssignableFrom(ftype)) {
                tname = "oidlist.tmpl";
            }
            if (ii > 0) {
                fsection.append(EOL);
                msection.append(EOL);
            }
            fsection.append(this.mergeTemplate(NAME_TMPL, data));
            msection.append(this.mergeTemplate(BASE_TMPL + tname, data));
        }
        this.writeFile(source.getAbsolutePath(), sfile.generate(fsection.toString(), msection.toString()));
    }
}

