/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools.cpp;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.threerings.presents.tools.GenReceiverTask;
import com.threerings.presents.tools.ImportSet;
import com.threerings.presents.tools.InvocationTask;
import com.threerings.presents.tools.cpp.CPPArgBuilder;
import com.threerings.presents.tools.cpp.CPPType;
import com.threerings.presents.tools.cpp.CPPUtil;
import com.threerings.presents.tools.cpp.MethodDescriptor;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenCPPReceiverTask
extends GenReceiverTask {
    protected File _cpproot;
    protected static final String RECEIVER_HEADER_TMPL = "com/threerings/presents/tools/cpp/receiver_h.mustache";
    protected static final String DECODER_HEADER_TMPL = "com/threerings/presents/tools/cpp/decoder_h.mustache";
    protected static final String DECODER_CPP_TMPL = "com/threerings/presents/tools/cpp/decoder_cpp.mustache";

    public void setCpproot(File asroot) {
        this._cpproot = asroot;
    }

    @Override
    protected void generateDecoder(Class<?> receiver, File source, String rname, String rpackage, List<InvocationTask.ServiceMethod> methods, ImportSet imports, String rcode) throws Exception {
        String dname = rname.replace("Receiver", "Decoder");
        HashMap ctx = Maps.newHashMap();
        List<String> namespaces = CPPUtil.makeNamespaces(receiver);
        ctx.put("receiverName", rname);
        ctx.put("decoderName", dname);
        ctx.put("namespaces", namespaces);
        ctx.put("namespace", CPPUtil.makeNamespace(receiver));
        ctx.put("package", rpackage);
        ctx.put("methods", MethodDescriptor.from(methods));
        ctx.put("receiverCode", rcode);
        ctx.put("argbuilder", new CPPArgBuilder());
        this.writeTemplate(DECODER_HEADER_TMPL, CPPUtil.makePath(this._cpproot, namespaces, dname, ".h"), ctx);
        TreeSet receiverHeaderIncludes = Sets.newTreeSet();
        TreeSet decoderImplIncludes = Sets.newTreeSet();
        for (InvocationTask.ServiceMethod meth : methods) {
            Type[] typeArray = meth.method.getGenericParameterTypes();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                CPPType cppType = new CPPType(type);
                if (cppType.primitive) {
                    decoderImplIncludes.add("presents/box/Boxed" + cppType.interpreter + ".h");
                }
                while (cppType != null) {
                    if (cppType.representationImport != null) {
                        receiverHeaderIncludes.add(cppType.representationImport);
                    }
                    cppType = cppType.dependent;
                }
                ++n2;
            }
        }
        ctx.put("includes", decoderImplIncludes);
        this.writeTemplate(DECODER_CPP_TMPL, CPPUtil.makePath(this._cpproot, namespaces, dname, ".cpp"), ctx);
        ctx.put("includes", receiverHeaderIncludes);
        this.writeTemplate(RECEIVER_HEADER_TMPL, CPPUtil.makePath(this._cpproot, namespaces, rname, ".h"), ctx);
        super.generateDecoder(receiver, source, rname, rpackage, methods, imports, rcode);
    }
}

