/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.collect.Lists;
import com.samskivert.util.StringUtil;
import com.threerings.presents.tools.GenUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;

public class SourceFile {
    protected List<String> _lines;
    protected int _nstart = -1;
    protected int _nend = -1;
    protected int _mstart = -1;
    protected int _mend = -1;
    protected static final String MARKER = "// AUTO-GENERATED: ";
    protected static final String FIELDS_START = "// AUTO-GENERATED: FIELDS START";
    protected static final String FIELDS_END = "// AUTO-GENERATED: FIELDS END";
    protected static final String METHODS_START = "// AUTO-GENERATED: METHODS START";
    protected static final String METHODS_END = "// AUTO-GENERATED: METHODS END";

    public void readFrom(File source) throws IOException {
        this._lines = Lists.newArrayList();
        BufferedReader bin = new BufferedReader(new FileReader(source));
        String line = null;
        while ((line = bin.readLine()) != null) {
            this._lines.add(line);
        }
        bin.close();
        int bstart = -1;
        int bend = -1;
        int ii = 0;
        int nn = this._lines.size();
        while (ii < nn) {
            line = this._lines.get(ii).trim();
            if (GenUtil.NAME_PATTERN.matcher(line).find()) {
                if (line.endsWith("{")) {
                    bstart = ii + 1;
                } else {
                    int oo = 1;
                    while (oo < 10) {
                        if (this.safeGetLine(ii + oo).trim().endsWith("{")) {
                            bstart = ii + oo + 1;
                            break;
                        }
                        ++oo;
                    }
                }
            } else if (line.equals("}")) {
                bend = ii;
            } else if (line.equals(FIELDS_START)) {
                this._nstart = ii;
            } else if (line.equals(FIELDS_END)) {
                this._nend = ii + 1;
            } else if (line.equals(METHODS_START)) {
                this._mstart = ii;
            } else if (line.equals(METHODS_END)) {
                this._mend = ii + 1;
            }
            ++ii;
        }
        this.check(source, "fields start", this._nstart, "fields end", this._nend);
        this.check(source, "fields end", this._nend, "fields start", this._nstart);
        this.check(source, "methods start", this._mstart, "methods end", this._mend);
        this.check(source, "methods end", this._mend, "methods start", this._mstart);
        if (this._nstart == -1) {
            this._nstart = bstart;
            this._nend = bstart;
        }
        if (this._mstart == -1) {
            this._mstart = bend;
            this._mend = bend;
        }
    }

    public boolean containsString(String text) {
        int ii = 0;
        int nn = this._lines.size();
        while (ii < nn) {
            if (!(ii >= this._nstart && ii < this._nend || ii >= this._mstart && ii < this._mend || !this._lines.get(ii).contains(text))) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public String generate(String fsection, String msection) throws IOException {
        StringWriter writer = new StringWriter();
        BufferedWriter bout = new BufferedWriter(writer);
        this.addOrRemoveGeneratedImport(StringUtil.deNull((String)fsection).contains("@Generated(") || StringUtil.deNull((String)msection).contains("@Generated("));
        int ii = 0;
        while (ii < this._nstart) {
            this.writeln(bout, this._lines.get(ii));
            ++ii;
        }
        if (!StringUtil.isBlank((String)fsection)) {
            String prev = this.safeGetLine(this._nstart - 1);
            if (!StringUtil.isBlank((String)prev) && !prev.equals("{")) {
                bout.newLine();
            }
            this.writeln(bout, "    // AUTO-GENERATED: FIELDS START");
            bout.write(fsection);
            this.writeln(bout, "    // AUTO-GENERATED: FIELDS END");
            if (!StringUtil.isBlank((String)this.safeGetLine(this._nend))) {
                bout.newLine();
            }
        }
        ii = this._nend;
        while (ii < this._mstart) {
            this.writeln(bout, this._lines.get(ii));
            ++ii;
        }
        if (!StringUtil.isBlank((String)msection)) {
            if (!StringUtil.isBlank((String)this.safeGetLine(this._mstart - 1))) {
                bout.newLine();
            }
            this.writeln(bout, "    // AUTO-GENERATED: METHODS START");
            bout.write(msection);
            this.writeln(bout, "    // AUTO-GENERATED: METHODS END");
            String next = this.safeGetLine(this._mend);
            if (!StringUtil.isBlank((String)next) && !next.equals("}")) {
                bout.newLine();
            }
        }
        ii = this._mend;
        int nn = this._lines.size();
        while (ii < nn) {
            this.writeln(bout, this._lines.get(ii));
            ++ii;
        }
        bout.close();
        return writer.toString();
    }

    protected void check(File source, String mname, int mline, String fname, int fline) throws IOException {
        if (mline == -1 && fline != -1) {
            throw new IOException("Found " + fname + " marker (at line " + (fline + 1) + ") but no " + mname + " marker in '" + source + "'.");
        }
    }

    protected String safeGetLine(int index) {
        return index < this._lines.size() ? this._lines.get(index) : "";
    }

    protected void writeln(BufferedWriter bout, String line) throws IOException {
        bout.write(line);
        bout.newLine();
    }

    protected void addOrRemoveGeneratedImport(boolean add) {
        String IMPORT = "import javax.annotation.Generated;";
        int packageLine = -1;
        int importLine = -1;
        int lastJavaImport = -1;
        int firstNonJavaImport = -1;
        int ii = 0;
        int nn = this._lines.size();
        while (ii < nn) {
            String line = this._lines.get(ii);
            if (line.startsWith("import javax.annotation.Generated;")) {
                if (add) {
                    return;
                }
                importLine = ii;
                break;
            }
            if (line.startsWith("package ")) {
                packageLine = ii;
            } else if (line.startsWith("import java")) {
                lastJavaImport = ii;
            } else if (firstNonJavaImport == -1 && line.startsWith("import ")) {
                firstNonJavaImport = ii;
            }
            ++ii;
        }
        if (importLine != -1) {
            this._lines.remove(importLine);
        } else {
            if (!add) {
                return;
            }
            importLine = lastJavaImport != -1 ? lastJavaImport + 1 : (firstNonJavaImport != -1 ? firstNonJavaImport : packageLine + 1);
            this._lines.add(importLine, "import javax.annotation.Generated;");
        }
        int adjustment = add ? 1 : -1;
        this._nstart += adjustment;
        this._nend += adjustment;
        this._mstart += adjustment;
        this._mend += adjustment;
    }
}

