/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.io.StreamUtil;
import com.threerings.io.BasicStreamers;
import com.threerings.io.FieldMarshaller;
import com.threerings.io.Streamable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class InstrumentStreamableTask
extends Task {
    protected ArrayList<FileSet> _filesets = Lists.newArrayList();
    protected ArrayList<Path> _paths = Lists.newArrayList();
    protected File _outdir;
    protected ClassPool _pool = ClassPool.getDefault();
    protected CtClass _streamable;
    protected static final String BSNAME = BasicStreamers.class.getName();

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void addPath(Path path) {
        this._paths.add(path);
    }

    public void setOutdir(File outdir) {
        this._outdir = outdir;
    }

    public void execute() {
        for (Path path : this._paths) {
            String[] stringArray = path.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                try {
                    this._pool.appendClassPath(element);
                }
                catch (NotFoundException nfe) {
                    System.err.println("Invalid classpath entry [path=" + element + "]: " + (Object)((Object)nfe));
                }
                ++n2;
            }
        }
        try {
            this._streamable = this._pool.get(Streamable.class.getName());
        }
        catch (Exception e) {
            throw new BuildException("Unable to load " + Streamable.class.getName() + ": " + e);
        }
        for (FileSet fs : this._filesets) {
            String[] srcFiles;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] stringArray = srcFiles = ds.getIncludedFiles();
            int n = srcFiles.length;
            int n3 = 0;
            while (n3 < n) {
                String srcFile = stringArray[n3];
                this.processClass(new File(fromDir, srcFile));
                ++n3;
            }
        }
    }

    protected void processClass(File source) {
        CtClass clazz;
        BufferedInputStream in = null;
        try {
            try {
                in = new BufferedInputStream(new FileInputStream(source));
                clazz = this._pool.makeClass((InputStream)in);
            }
            catch (IOException ioe) {
                System.err.println("Failed to load " + source + ": " + ioe);
                StreamUtil.close((InputStream)in);
                return;
            }
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close((InputStream)in);
        try {
            if (clazz.subtypeOf(this._streamable)) {
                this.processStreamable(source, clazz);
            }
        }
        catch (NotFoundException nfe) {
            System.err.println("Error processing class [class=" + clazz.getName() + ", error=" + (Object)((Object)nfe) + "].");
        }
    }

    protected void processStreamable(File source, CtClass clazz) throws NotFoundException {
        ArrayList fields = Lists.newArrayList();
        CtField[] ctFieldArray = clazz.getDeclaredFields();
        int n = ctFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtField field = ctFieldArray[n2];
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic((int)modifiers) && !Modifier.isTransient((int)modifiers) && (Modifier.isProtected((int)modifiers) || Modifier.isPrivate((int)modifiers))) {
                fields.add(field);
            }
            ++n2;
        }
        HashSet methods = Sets.newHashSet();
        CtMethod[] modifiers = clazz.getMethods();
        int n3 = modifiers.length;
        n = 0;
        while (n < n3) {
            CtMethod method = modifiers[n];
            methods.add(method.getName());
            ++n;
        }
        int added = 0;
        for (CtField field : fields) {
            String wname;
            String rname = FieldMarshaller.getReaderMethodName((String)field.getName());
            if (!methods.contains(rname)) {
                String reader = "public void " + rname + " (com.threerings.io.ObjectInputStream ins) {\n" + "    " + this.getFieldReader(field) + "\n" + "}";
                try {
                    clazz.addMethod(CtNewMethod.make((String)reader, (CtClass)clazz));
                    ++added;
                }
                catch (CannotCompileException cce) {
                    System.err.println("Unable to compile reader [class=" + clazz.getName() + ", error=" + (Object)((Object)cce) + "]:");
                    System.err.println(reader);
                }
            }
            if (methods.contains(wname = FieldMarshaller.getWriterMethodName((String)field.getName()))) continue;
            String writer = "public void " + wname + " (com.threerings.io.ObjectOutputStream out) {\n" + "    " + this.getFieldWriter(field) + "\n" + "}";
            try {
                clazz.addMethod(CtNewMethod.make((String)writer, (CtClass)clazz));
                ++added;
            }
            catch (CannotCompileException cce) {
                System.err.println("Unable to compile writer [class=" + clazz.getName() + ", error=" + (Object)((Object)cce) + "]:");
                System.err.println(writer);
            }
        }
        if (added > 0) {
            try {
                System.out.println("Instrumented '" + clazz.getName() + "'.");
                clazz.writeFile(this._outdir.getPath());
            }
            catch (Exception e) {
                System.err.println("Failed to write instrumented class [class=" + clazz + ", outdir=" + this._outdir + "]: " + e);
            }
        }
    }

    protected String getFieldReader(CtField field) throws NotFoundException {
        CtClass type = field.getType();
        String name = field.getName();
        if (type.getName().equals("java.lang.String")) {
            return this.readWrap(field, String.valueOf(name) + " = ins.readUTF();");
        }
        if (type.equals(CtClass.booleanType) || type.getName().equals("java.lang.Boolean")) {
            return this.readWrap(field, String.valueOf(name) + " = ins.readBoolean();");
        }
        if (type.equals(CtClass.byteType) || type.getName().equals("java.lang.Byte")) {
            return this.readWrap(field, String.valueOf(name) + " = ins.readByte();");
        }
        if (type.equals(CtClass.shortType) || type.getName().equals("java.lang.Short")) {
            return this.readWrap(field, String.valueOf(name) + " = ins.readShort();");
        }
        if (type.equals(CtClass.intType) || type.getName().equals("java.lang.Integer")) {
            return this.readWrap(field, String.valueOf(name) + " = ins.readInt();");
        }
        if (type.equals(CtClass.longType) || type.getName().equals("java.lang.Long")) {
            return this.readWrap(field, String.valueOf(name) + " = ins.readLong();");
        }
        if (type.equals(CtClass.floatType) || type.getName().equals("java.lang.Float")) {
            return this.readWrap(field, String.valueOf(name) + " = ins.readFloat();");
        }
        if (type.equals(CtClass.doubleType) || type.getName().equals("java.lang.Double")) {
            return this.readWrap(field, String.valueOf(name) + " = ins.readDouble();");
        }
        if (type.isArray()) {
            CtClass ctype = type.getComponentType();
            if (ctype.equals(CtClass.booleanType)) {
                return this.readWrap(field, String.valueOf(name) + " = " + BSNAME + ".readBooleanArray(ins);");
            }
            if (ctype.equals(CtClass.byteType)) {
                return this.readWrap(field, String.valueOf(name) + " = " + BSNAME + ".readByteArray(ins);");
            }
            if (ctype.equals(CtClass.shortType)) {
                return this.readWrap(field, String.valueOf(name) + " = " + BSNAME + ".readShortArray(ins);");
            }
            if (ctype.equals(CtClass.intType)) {
                return this.readWrap(field, String.valueOf(name) + " = " + BSNAME + ".readIntArray(ins);");
            }
            if (ctype.equals(CtClass.longType)) {
                return this.readWrap(field, String.valueOf(name) + " = " + BSNAME + ".readLongArray(ins);");
            }
            if (ctype.equals(CtClass.floatType)) {
                return this.readWrap(field, String.valueOf(name) + " = " + BSNAME + ".readFloat(ins);");
            }
            if (ctype.equals(CtClass.doubleType)) {
                return this.readWrap(field, String.valueOf(name) + " = " + BSNAME + ".readDoubleArray(ins);");
            }
            if (ctype.getName().equals("java.lang.Object")) {
                return this.readWrap(field, String.valueOf(name) + " = " + BSNAME + ".readObjectArray(ins);");
            }
        }
        return String.valueOf(name) + " = (" + type.getName() + ")ins.readObject();";
    }

    protected String getFieldWriter(CtField field) throws NotFoundException {
        CtClass type = field.getType();
        String name = field.getName();
        if (type.equals(CtClass.booleanType) || type.getName().equals("java.lang.Boolean")) {
            return this.writeWrap(field, "out.writeBoolean(" + name + ");");
        }
        if (type.equals(CtClass.byteType) || type.getName().equals("java.lang.Byte")) {
            return this.writeWrap(field, "out.writeByte(" + name + ");");
        }
        if (type.equals(CtClass.shortType) || type.getName().equals("java.lang.Short")) {
            return this.writeWrap(field, "out.writeShort(" + name + ");");
        }
        if (type.equals(CtClass.intType) || type.getName().equals("java.lang.Integer")) {
            return this.writeWrap(field, "out.writeInt(" + name + ");");
        }
        if (type.equals(CtClass.longType) || type.getName().equals("java.lang.Long")) {
            return this.writeWrap(field, "out.writeLong(" + name + ");");
        }
        if (type.equals(CtClass.floatType) || type.getName().equals("java.lang.Float")) {
            return this.writeWrap(field, "out.writeFloat(" + name + ");");
        }
        if (type.equals(CtClass.doubleType) || type.getName().equals("java.lang.Double")) {
            return this.writeWrap(field, "out.writeDouble(" + name + ");");
        }
        if (type.getName().equals("java.lang.String")) {
            return this.writeWrap(field, "out.writeUTF(" + name + ");");
        }
        if (type.isArray()) {
            CtClass ctype = type.getComponentType();
            if (ctype.equals(CtClass.booleanType)) {
                return this.writeWrap(field, String.valueOf(BSNAME) + ".writeBooleanArray(out, " + name + ");");
            }
            if (ctype.equals(CtClass.byteType)) {
                return this.writeWrap(field, String.valueOf(BSNAME) + ".writeByteArray(out, " + name + ");");
            }
            if (ctype.equals(CtClass.shortType)) {
                return this.writeWrap(field, String.valueOf(BSNAME) + ".writeShortArray(out, " + name + ");");
            }
            if (ctype.equals(CtClass.intType)) {
                return this.writeWrap(field, String.valueOf(BSNAME) + ".writeIntArray(out, " + name + ");");
            }
            if (ctype.equals(CtClass.longType)) {
                return this.writeWrap(field, String.valueOf(BSNAME) + ".writeLongArray(out, " + name + ");");
            }
            if (ctype.equals(CtClass.floatType)) {
                return this.writeWrap(field, String.valueOf(BSNAME) + ".writeFloat(out, " + name + ");");
            }
            if (ctype.equals(CtClass.doubleType)) {
                return this.writeWrap(field, String.valueOf(BSNAME) + ".writeDoubleArray(out, " + name + ");");
            }
            if (ctype.getName().equals("java.lang.Object")) {
                return this.writeWrap(field, String.valueOf(BSNAME) + ".writeObjectArray(out, " + name + ");");
            }
        }
        return "out.writeObject(" + name + ");";
    }

    protected String readWrap(CtField field, String body) throws NotFoundException {
        if (field.getType().isPrimitive()) {
            return body;
        }
        return "if (ins.readBoolean()) {\n        " + body + "\n" + "    } else {\n" + "        " + field.getName() + " = null;\n" + "    }";
    }

    protected String writeWrap(CtField field, String body) throws NotFoundException {
        if (field.getType().isPrimitive()) {
            return body;
        }
        return "if (" + field.getName() + " == null) {\n" + "        out.writeBoolean(false);\n" + "    } else {\n" + "        out.writeBoolean(true);\n" + "        " + body + "\n" + "    }";
    }
}

