/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.collect.Lists;
import com.threerings.io.Streamable;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.tools.GenTask;
import com.threerings.presents.tools.GenUtil;
import com.threerings.presents.tools.SourceFile;
import com.threerings.presents.tools.StreamableClassRequirements;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenStreamableTask
extends GenTask {
    protected ArrayList<FileSet> _filesets = Lists.newArrayList();
    protected static final String READ_OPEN = "    // from interface Streamable\n    public void readObject (ObjectInputStream ins)\n        throws IOException, ClassNotFoundException\n    {\n";
    protected static final String READ_CLOSE = "    }\n";
    protected static final String WRITE_OPEN = "    // from interface Streamable\n    public void writeObject (ObjectOutputStream out)\n        throws IOException\n    {\n";
    protected static final String WRITE_CLOSE = "    }\n";

    @Override
    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    @Override
    public void execute() {
        for (FileSet fs : this._filesets) {
            String[] srcFiles;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] stringArray = srcFiles = ds.getIncludedFiles();
            int n = srcFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String srcFile = stringArray[n2];
                this.processClass(new File(fromDir, srcFile));
                ++n2;
            }
        }
    }

    protected void processClass(File source) {
        String name = null;
        try {
            name = GenUtil.readClassName(source);
        }
        catch (Exception e) {
            System.err.println("Failed to parse " + source + ": " + e.getMessage());
            return;
        }
        System.err.println("Considering " + name + "...");
        try {
            this.processClass(source, ((Object)((Object)this)).getClass().getClassLoader().loadClass(name));
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Failed to load " + name + ".\nMissing class: " + cnfe.getMessage());
            System.err.println("Be sure to set the 'classpathref' attribute to a classpath\nthat contains your projects invocation service classes.");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    protected void processClass(File source, Class<?> sclass) throws IOException {
        StreamableClassRequirements reqs = new StreamableClassRequirements(sclass);
        if (!Streamable.class.isAssignableFrom(sclass) || DObject.class.isAssignableFrom(sclass) || reqs.streamedFields.isEmpty()) {
            return;
        }
        StringBuilder readbuf = new StringBuilder(READ_OPEN);
        StringBuilder writebuf = new StringBuilder(WRITE_OPEN);
        if (reqs.superclassStreamable) {
            readbuf.append("        super.readObject(ins);\n");
            writebuf.append("        super.writeObject(out);\n");
        }
        for (Field field : reqs.streamedFields) {
            readbuf.append("        ");
            readbuf.append(field.getName()).append(" = ");
            readbuf.append(this.toReadObject(field));
            readbuf.append(";\n");
            writebuf.append("        out.");
            writebuf.append(this.toWriteObject(field));
            writebuf.append(";\n");
        }
        readbuf.append("    }\n");
        writebuf.append("    }\n");
        SourceFile sfile = new SourceFile();
        try {
            sfile.readFrom(source);
        }
        catch (IOException ioe) {
            System.err.println("Error reading " + source + ": " + ioe);
        }
        StringBuilder methods = new StringBuilder();
        if (!sfile.containsString("public void readObject")) {
            methods.append((CharSequence)readbuf);
        }
        if (!sfile.containsString("public void writeObject")) {
            if (methods.length() > 0) {
                methods.append("\n");
            }
            methods.append((CharSequence)writebuf);
        }
        if (methods.length() == 0) {
            return;
        }
        System.err.println("Converting " + sclass.getName() + "...");
        this.writeFile(source.getAbsolutePath(), sfile.generate(null, methods.toString()));
    }

    protected String toReadObject(Field field) {
        Class<?> type = field.getType();
        if (type.equals(String.class)) {
            return "ins.readUTF()";
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return "ins.readBoolean()";
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return "ins.readByte()";
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return "ins.readShort()";
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return "ins.readInt()";
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return "ins.readLong()";
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return "ins.readFloat()";
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return "ins.readDouble()";
        }
        return "(" + GenUtil.simpleName((Field)field) + ")ins.readObject()";
    }

    protected String toWriteObject(Field field) {
        Class<?> type = field.getType();
        String name = field.getName();
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return "writeBoolean(" + name + ")";
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return "writeByte(" + name + ")";
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return "writeShort(" + name + ")";
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return "writeInt(" + name + ")";
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return "writeLong(" + name + ")";
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return "writeFloat(" + name + ")";
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return "writeDouble(" + name + ")";
        }
        if (type.equals(String.class)) {
            return "writeUTF(" + name + ")";
        }
        return "writeObject(" + name + ")";
    }
}

