/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.threerings.presents.tools.ImportSet;
import com.threerings.util.ActionScript;
import com.threerings.util.StreamableArrayList;
import com.threerings.util.StreamableHashMap;
import com.threerings.util.StreamableHashSet;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionScriptUtils {
    protected static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    protected static final Pattern AS_PUBLIC_CLASS_DECL = Pattern.compile("^public class(.*)$", 8);
    protected static final Pattern AS_IMPORT = Pattern.compile("^(\\s*)import(\\s+)([^;]*);", 8);

    public static void addExistingImports(String asFile, ImportSet imports) {
        Matcher m = AS_PUBLIC_CLASS_DECL.matcher(asFile);
        int searchTo = asFile.length();
        if (m.find()) {
            searchTo = m.start();
        }
        m = AS_IMPORT.matcher(asFile.substring(0, searchTo));
        while (m.find()) {
            imports.add(m.group(3));
        }
    }

    public static String addImportAndGetShortType(Class<?> type, boolean isField, ImportSet imports) {
        String full = ActionScriptUtils.toActionScriptType(type, isField);
        if (ActionScriptUtils.needsActionScriptImport(type, isField)) {
            imports.add(full);
        }
        return (String)Iterables.getLast((Iterable)DOT_SPLITTER.split((CharSequence)full));
    }

    public static String toSimpleName(Class<?> type) {
        String name = type.getName().substring(type.getName().lastIndexOf(".") + 1);
        return name.replaceAll("\\$", "_");
    }

    public static String toReadObject(Class<?> type) {
        if (type.equals(String.class)) {
            return "readField(String)";
        }
        if (type.equals(Integer.class) || type.equals(Short.class) || type.equals(Byte.class)) {
            return "readField(" + ActionScriptUtils.toSimpleName(type) + ").value";
        }
        if (type.equals(Long.class)) {
            return "readField(" + ActionScriptUtils.toSimpleName(type) + ")";
        }
        if (type.equals(Boolean.TYPE)) {
            return "readBoolean()";
        }
        if (type.equals(Byte.TYPE)) {
            return "readByte()";
        }
        if (type.equals(Short.TYPE) || type.equals(Character.TYPE)) {
            return "readShort()";
        }
        if (type.equals(Integer.TYPE)) {
            return "readInt()";
        }
        if (type.equals(Long.TYPE)) {
            return "readLong()";
        }
        if (type.equals(Float.TYPE)) {
            return "readFloat()";
        }
        if (type.equals(Double.TYPE)) {
            return "readDouble()";
        }
        if (ActionScriptUtils.isNaiveMap(type)) {
            return "readField(MapStreamer.INSTANCE)";
        }
        if (ActionScriptUtils.isNaiveList(type)) {
            return "readField(ArrayStreamer.INSTANCE)";
        }
        if (ActionScriptUtils.isNaiveSet(type)) {
            return "readField(SetStreamer.INSTANCE)";
        }
        if (type.isArray()) {
            if (!type.getComponentType().isPrimitive()) {
                return "readObject(TypedArray)";
            }
            if (Double.TYPE.equals(type.getComponentType())) {
                return "readField(TypedArray.getJavaType(Number))";
            }
            if (Boolean.TYPE.equals(type.getComponentType())) {
                return "readField(TypedArray.getJavaType(Boolean))";
            }
            if (Integer.TYPE.equals(type.getComponentType())) {
                return "readField(TypedArray.getJavaType(int))";
            }
            if (Byte.TYPE.equals(type.getComponentType())) {
                return "readField(ByteArray)";
            }
            throw new IllegalArgumentException(type + " isn't supported to stream to actionscript");
        }
        return "readObject(" + (String)Iterables.getLast((Iterable)DOT_SPLITTER.split((CharSequence)ActionScriptUtils.toActionScriptType(type, false))) + ")";
    }

    public static String toWriteObject(Class<?> type, String name) {
        if (type.equals(Integer.class)) {
            return "writeObject(new Integer(" + name + "))";
        }
        if (type.equals(Boolean.TYPE)) {
            return "writeBoolean(" + name + ")";
        }
        if (type.equals(Byte.TYPE)) {
            return "writeByte(" + name + ")";
        }
        if (type.equals(Short.TYPE) || type.equals(Character.TYPE)) {
            return "writeShort(" + name + ")";
        }
        if (type.equals(Integer.TYPE)) {
            return "writeInt(" + name + ")";
        }
        if (type.equals(Long.TYPE)) {
            return "writeLong(" + name + ")";
        }
        if (type.equals(Float.TYPE)) {
            return "writeFloat(" + name + ")";
        }
        if (type.equals(Double.TYPE)) {
            return "writeDouble(" + name + ")";
        }
        if (type.equals(Long.class) || type.equals(String.class) || type.isArray() && type.getComponentType().isPrimitive()) {
            return "writeField(" + name + ")";
        }
        if (ActionScriptUtils.isNaiveList(type)) {
            return "writeField(" + name + ", ArrayStreamer.INSTANCE)";
        }
        if (ActionScriptUtils.isNaiveMap(type)) {
            return "writeField(" + name + ", MapStreamer.INSTANCE)";
        }
        if (ActionScriptUtils.isNaiveSet(type)) {
            return "writeField(" + name + ", SetStreamer.INSTANCE)";
        }
        return "writeObject(" + name + ")";
    }

    public static String toActionScriptType(Class<?> type, boolean isField) {
        if (type.isArray() || ActionScriptUtils.isNaiveList(type)) {
            if (Byte.TYPE.equals(type.getComponentType())) {
                return "flash.utils.ByteArray";
            }
            if (isField) {
                return "com.threerings.io.TypedArray";
            }
            return "Array";
        }
        if (ActionScriptUtils.isNaiveMap(type)) {
            return "com.threerings.util.Map";
        }
        if (ActionScriptUtils.isNaiveSet(type)) {
            return "com.threerings.util.Set";
        }
        if (Integer.TYPE.equals(type) || Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Character.TYPE.equals(type)) {
            return "int";
        }
        if (Float.TYPE.equals(type) || Double.TYPE.equals(type)) {
            return "Number";
        }
        if (Long.TYPE.equals(type)) {
            return "com.threerings.util.Long";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Boolean";
        }
        if (Cloneable.class.equals(type)) {
            return "com.threerings.util.Cloneable";
        }
        if (Comparable.class.equals(type)) {
            return "com.threerings.util.Comparable";
        }
        return type.getName().replaceAll("\\$", "_");
    }

    public static void convertBaseClasses(ImportSet imports) {
        imports.replace("byte", "com.threerings.util.Byte");
        imports.replace("boolean", "com.threerings.util.langBoolean");
        imports.replace("[B", "flash.utils.ByteArray");
        imports.replace("float", "com.threerings.util.Float");
        imports.replace("long", "com.threerings.util.Long");
        if (imports.removeAll("[*") > 0) {
            imports.add("com.threerings.io.TypedArray");
        }
        imports.replace(Integer.class, "com.threerings.util.Integer");
        imports.replace(Map.class, "com.threerings.util.Map");
        imports.removeGlobals();
        imports.removeArrays();
    }

    public static File createActionScriptPath(File actionScriptRoot, Class<?> sclass) {
        String path = ActionScriptUtils.toActionScriptType(sclass, false).replace(".", File.separator);
        return new File(actionScriptRoot, String.valueOf(path) + ".as");
    }

    public static boolean hasOmitAnnotation(Class<?> cclass) {
        do {
            ActionScript asa;
            if ((asa = cclass.getAnnotation(ActionScript.class)) == null || !asa.omit()) continue;
            return true;
        } while ((cclass = cclass.getSuperclass()) != null);
        return false;
    }

    protected static boolean isNaiveMap(Class<?> type) {
        return Map.class.isAssignableFrom(type) && !type.equals(StreamableHashMap.class);
    }

    protected static boolean isNaiveSet(Class<?> type) {
        return Set.class.isAssignableFrom(type) && !type.equals(StreamableHashSet.class);
    }

    protected static boolean isNaiveList(Class<?> type) {
        return List.class.isAssignableFrom(type) && !type.equals(StreamableArrayList.class);
    }

    protected static boolean needsActionScriptImport(Class<?> type, boolean isField) {
        if (type.isArray()) {
            return Byte.TYPE.equals(type.getComponentType()) || isField;
        }
        return (Long.TYPE.equals(type) || !type.isPrimitive()) && !String.class.equals(type);
    }
}

