/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.threerings.media.util.TrailingAverage;
import java.util.Arrays;

public class TruncatedAverage
extends TrailingAverage {
    protected int _omitLowest;
    protected int _omitHighest;
    protected int[] _sorted;
    protected int _value;

    public TruncatedAverage() {
        this(10, 3, 3);
    }

    public TruncatedAverage(int history, int omitLowest, int omitHighest) {
        super(history);
        this._omitLowest = omitLowest;
        this._omitHighest = omitHighest;
        this._sorted = new int[history];
    }

    public void record(int value) {
        super.record(value);
        int end = Math.min(this._history.length, this._index);
        System.arraycopy(this._history, 0, this._sorted, 0, end);
        Arrays.sort(this._sorted, 0, end);
        int total = 0;
        int first = this._omitLowest * end / this._history.length;
        int last = end - this._omitHighest * end / this._history.length;
        int ii = first;
        while (ii < last) {
            total += this._sorted[ii];
            ++ii;
        }
        this._value = total / (last - first);
    }

    public int value() {
        return this._value;
    }
}

