/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.collect.Lists;
import com.samskivert.util.ListUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.ConditionConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActionLogic;
import com.threerings.tudey.server.logic.ExpressionLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.RegionLogic;
import com.threerings.tudey.server.logic.TargetLogic;
import com.threerings.tudey.shape.Shape;
import java.util.ArrayList;
import java.util.Map;

public abstract class ConditionLogic
extends Logic {
    protected ConditionConfig _config;
    protected Logic _source;

    public void init(TudeySceneManager scenemgr, ConditionConfig config, Logic source) {
        super.init(scenemgr);
        this._config = config;
        this._source = source;
        this.didInit();
    }

    public abstract boolean isSatisfied(Logic var1);

    @Override
    public boolean isActive() {
        return this._source.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._source.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._source.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._source.getRotation();
    }

    protected void didInit() {
    }

    public static class Action
    extends ConditionLogic {
        protected ActionLogic _action;

        @Override
        public boolean isSatisfied(Logic activator) {
            return this._action.execute(this._scenemgr.getTimestamp(), activator);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._action.transfer(((Action)source)._action, refs);
        }

        @Override
        protected void didInit() {
            this._action = this.createAction(((ConditionConfig.Action)this._config).action, this._source);
        }
    }

    public static class All
    extends ConditionLogic {
        protected ConditionLogic[] _conditions;

        @Override
        public boolean isSatisfied(Logic activator) {
            ConditionLogic[] conditionLogicArray = this._conditions;
            int n = this._conditions.length;
            int n2 = 0;
            while (n2 < n) {
                ConditionLogic condition = conditionLogicArray[n2];
                if (!condition.isSatisfied(activator)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ConditionLogic[] sconditions = ((All)source)._conditions;
            int ii = 0;
            while (ii < this._conditions.length) {
                this._conditions[ii].transfer(sconditions[ii], refs);
                ++ii;
            }
        }

        @Override
        protected void didInit() {
            ArrayList list = Lists.newArrayList();
            ConditionConfig[] conditionConfigArray = ((ConditionConfig.All)this._config).conditions;
            int n = ((ConditionConfig.All)this._config).conditions.length;
            int n2 = 0;
            while (n2 < n) {
                ConditionConfig config = conditionConfigArray[n2];
                ConditionLogic condition = this.createCondition(config, this._source);
                if (condition != null) {
                    list.add(condition);
                }
                ++n2;
            }
            this._conditions = list.toArray(new ConditionLogic[list.size()]);
        }
    }

    public static class Always
    extends ConditionLogic {
        @Override
        public boolean isSatisfied(Logic activator) {
            return true;
        }
    }

    public static class Any
    extends ConditionLogic {
        protected ConditionLogic[] _conditions;

        @Override
        public boolean isSatisfied(Logic activator) {
            ConditionLogic[] conditionLogicArray = this._conditions;
            int n = this._conditions.length;
            int n2 = 0;
            while (n2 < n) {
                ConditionLogic condition = conditionLogicArray[n2];
                if (condition.isSatisfied(activator)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            ConditionLogic[] sconditions = ((Any)source)._conditions;
            int ii = 0;
            while (ii < this._conditions.length) {
                this._conditions[ii].transfer(sconditions[ii], refs);
                ++ii;
            }
        }

        @Override
        protected void didInit() {
            ArrayList list = Lists.newArrayList();
            ConditionConfig[] conditionConfigArray = ((ConditionConfig.Any)this._config).conditions;
            int n = ((ConditionConfig.Any)this._config).conditions.length;
            int n2 = 0;
            while (n2 < n) {
                ConditionConfig config = conditionConfigArray[n2];
                ConditionLogic condition = this.createCondition(config, this._source);
                if (condition != null) {
                    list.add(condition);
                }
                ++n2;
            }
            this._conditions = list.toArray(new ConditionLogic[list.size()]);
        }
    }

    public static class Cooldown
    extends ConditionLogic {
        protected int _nextTimestamp = -1;

        @Override
        public boolean isSatisfied(Logic activator) {
            int timestamp = this._scenemgr.getTimestamp();
            if (timestamp > this._nextTimestamp) {
                this._nextTimestamp = timestamp + ((ConditionConfig.Cooldown)this._config).time;
                return true;
            }
            return false;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._nextTimestamp = ((Cooldown)source)._nextTimestamp;
        }
    }

    public static class DateRange
    extends Targeted {
        @Override
        public boolean isSatisfied(Logic activator) {
            ConditionConfig.DateRange config = (ConditionConfig.DateRange)this._config;
            long now = System.currentTimeMillis();
            return !(config.start != null && now < config.start || config.end != null && now > config.end);
        }
    }

    public static class DistanceWithin
    extends ConditionLogic {
        protected TargetLogic _first;
        protected TargetLogic _second;
        protected ArrayList<Logic> _firsts = Lists.newArrayList();
        protected ArrayList<Logic> _seconds = Lists.newArrayList();

        @Override
        public boolean isSatisfied(Logic activator) {
            boolean all = ((ConditionConfig.DistanceWithin)this._config).allFirst;
            this._first.resolve(activator, this._firsts);
            this._second.resolve(activator, this._seconds);
            try {
                int ii = 0;
                int nn = this._firsts.size();
                while (ii < nn) {
                    if (this.withinSecond(this._firsts.get(ii).getTranslation()) != all) {
                        boolean bl = !all;
                        return bl;
                    }
                    ++ii;
                }
                boolean bl = all;
                return bl;
            }
            finally {
                this._firsts.clear();
                this._seconds.clear();
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            DistanceWithin dsource = (DistanceWithin)source;
            this._first.transfer(dsource._first, refs);
            this._second.transfer(dsource._second, refs);
        }

        @Override
        protected void didInit() {
            ConditionConfig.DistanceWithin config = (ConditionConfig.DistanceWithin)this._config;
            this._first = this.createTarget(config.first, this._source);
            this._second = this.createTarget(config.second, this._source);
        }

        protected boolean withinSecond(Vector2f t1) {
            ConditionConfig.DistanceWithin config = (ConditionConfig.DistanceWithin)this._config;
            int ii = 0;
            int nn = this._seconds.size();
            while (ii < nn) {
                Vector2f t2 = this._seconds.get(ii).getTranslation();
                if (FloatMath.isWithin(t1.distance(t2), config.minimum, config.maximum) != config.allSecond) {
                    return !config.allSecond;
                }
                ++ii;
            }
            return config.allSecond;
        }
    }

    public static class Evaluate
    extends ConditionLogic {
        protected ExpressionLogic _expression;

        @Override
        public boolean isSatisfied(Logic activator) {
            return ExpressionLogic.coerceToBoolean(this._expression.evaluate(activator, null));
        }

        @Override
        protected void didInit() {
            this._expression = this.createExpression(((ConditionConfig.Evaluate)this._config).expression, this._source);
        }
    }

    public static class FlagSet
    extends Targeted {
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        /*
         * Exception decompiling
         */
        @Override
        public boolean isSatisfied(Logic activator) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ConditionConfig.FlagSet)this._config).target, this._source);
        }
    }

    public static class InstanceOf
    extends Targeted {
        protected Class<?> _logicClass;
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        @Override
        public boolean isSatisfied(Logic activator) {
            boolean all = ((ConditionConfig.InstanceOf)this._config).all;
            this._target.resolve(activator, this._targets);
            try {
                int ii = 0;
                int nn = this._targets.size();
                while (ii < nn) {
                    if (this._logicClass.isInstance(this._targets.get(ii)) != all) {
                        boolean bl = !all;
                        return bl;
                    }
                    ++ii;
                }
                boolean bl = all;
                return bl;
            }
            finally {
                this._targets.clear();
            }
        }

        @Override
        protected void didInit() {
            ConditionConfig.InstanceOf config = (ConditionConfig.InstanceOf)this._config;
            try {
                this._logicClass = Class.forName(config.logicClass);
            }
            catch (ClassNotFoundException e) {
                Log.log.warning((Object)"Missing logic class for InstanceOf condition.", new Object[]{e});
                this._logicClass = Logic.class;
            }
            this._target = this.createTarget(config.target, this._source);
        }
    }

    public static class Intersecting
    extends ConditionLogic {
        protected RegionLogic _first;
        protected RegionLogic _second;
        protected ArrayList<Shape> _firsts = Lists.newArrayList();
        protected ArrayList<Shape> _seconds = Lists.newArrayList();

        @Override
        public boolean isSatisfied(Logic activator) {
            boolean all = ((ConditionConfig.Intersecting)this._config).allFirst;
            this._first.resolve(activator, this._firsts);
            this._second.resolve(activator, this._seconds);
            try {
                int ii = 0;
                int nn = this._firsts.size();
                while (ii < nn) {
                    if (this.intersectsSecond(this._firsts.get(ii)) != all) {
                        boolean bl = !all;
                        return bl;
                    }
                    ++ii;
                }
                boolean bl = all;
                return bl;
            }
            finally {
                this._firsts.clear();
                this._seconds.clear();
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Intersecting isource = (Intersecting)source;
            this._first.transfer(isource._first, refs);
            this._second.transfer(isource._second, refs);
        }

        @Override
        protected void didInit() {
            ConditionConfig.Intersecting config = (ConditionConfig.Intersecting)this._config;
            this._first = this.createRegion(config.first, this._source);
            this._second = this.createRegion(config.second, this._source);
        }

        protected boolean intersectsSecond(Shape shape) {
            boolean all = ((ConditionConfig.Intersecting)this._config).allSecond;
            int ii = 0;
            int nn = this._seconds.size();
            while (ii < nn) {
                if (shape.intersects(this._seconds.get(ii)) != all) {
                    return !all;
                }
                ++ii;
            }
            return all;
        }
    }

    public static class IntersectsScene
    extends ConditionLogic {
        protected RegionLogic _region;
        protected ArrayList<Shape> _shapes = Lists.newArrayList();

        @Override
        public boolean isSatisfied(Logic activator) {
            this._region.resolve(activator, this._shapes);
            try {
                for (Shape shape : this._shapes) {
                    if (!this._scenemgr.collides(((ConditionConfig.IntersectsScene)this._config).collisionMask, shape)) continue;
                    return true;
                }
                return false;
            }
            finally {
                this._shapes.clear();
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._region.transfer(((IntersectsScene)source)._region, refs);
        }

        @Override
        protected void didInit() {
            this._region = this.createRegion(((ConditionConfig.IntersectsScene)this._config).region, this._source);
        }
    }

    public static class Is
    extends Targeted {
        protected ArrayList<Logic> _targets = Lists.newArrayList();
        protected TargetLogic _sourceTarget;

        @Override
        public boolean isSatisfied(Logic activator) {
            this._sourceTarget.resolve(activator, this._targets);
            Logic sourceTarget = this._targets.isEmpty() ? null : this._targets.get(0);
            this._targets.clear();
            if (sourceTarget == null) {
                return false;
            }
            ConditionConfig.Is config = (ConditionConfig.Is)this._config;
            this._target.resolve(activator, this._targets);
            try {
                for (Logic target : this._targets) {
                    if (target != sourceTarget) continue;
                    boolean bl = !config.all;
                    return bl;
                }
                boolean bl = config.all;
                return bl;
            }
            finally {
                this._targets.clear();
            }
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ConditionConfig.Is)this._config).target, this._source);
            this._sourceTarget = this.createTarget(((ConditionConfig.Is)this._config).source, this._source);
        }
    }

    public static class Limit
    extends ConditionLogic {
        protected int _limit;

        @Override
        public boolean isSatisfied(Logic activator) {
            if (this._limit > 0) {
                --this._limit;
                return true;
            }
            return false;
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._limit = ((Limit)source)._limit;
        }

        @Override
        protected void didInit() {
            this._limit = ((ConditionConfig.Limit)this._config).limit;
        }
    }

    public static class Not
    extends ConditionLogic {
        protected ConditionLogic _condition;

        @Override
        public boolean isSatisfied(Logic activator) {
            return !this._condition.isSatisfied(activator);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._condition.transfer(((Not)source)._condition, refs);
        }

        @Override
        protected void didInit() {
            this._condition = this.createCondition(((ConditionConfig.Not)this._config).condition, this._source);
        }
    }

    public static class Random
    extends ConditionLogic {
        @Override
        public boolean isSatisfied(Logic activator) {
            return FloatMath.random() < ((ConditionConfig.Random)this._config).probability;
        }
    }

    public static class Tagged
    extends Targeted {
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        @Override
        public boolean isSatisfied(Logic activator) {
            ConditionConfig.Tagged config = (ConditionConfig.Tagged)this._config;
            this._target.resolve(activator, this._targets);
            try {
                int ii = 0;
                int nn = this._targets.size();
                while (ii < nn) {
                    if (ListUtil.contains((Object[])this._targets.get(ii).getTags(), (Object)config.tag) != config.all) {
                        boolean bl = !config.all;
                        return bl;
                    }
                    ++ii;
                }
                boolean bl = config.all;
                return bl;
            }
            finally {
                this._targets.clear();
            }
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ConditionConfig.Tagged)this._config).target, this._source);
        }
    }

    public static abstract class Targeted
    extends ConditionLogic {
        protected TargetLogic _target;

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((Targeted)source)._target, refs);
        }
    }
}

