/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.effect.Easing;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.ViewerEffect;
import com.threerings.opengl.scene.config.ViewerEffectConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.config.CameraConfig;

@EditorTypes(value={Camera.class})
public abstract class TudeyViewerEffectConfig
extends ViewerEffectConfig {

    public static class Camera
    extends TudeyViewerEffectConfig {
        @Editable(min=0.0, step=0.01)
        public float transition;
        @Editable
        public Easing easing = new Easing.None();
        @Editable
        public CameraConfig camera = new CameraConfig();
        @Editable
        public CameraConfig[] cameras = new CameraConfig[0];

        @Override
        public ViewerEffect getViewerEffect(GlContext ctx, Scope scope, ViewerEffect effect) {
            TudeySceneView view = ScopeUtil.resolve(scope, "view:this", null, TudeySceneView.class);
            if (view == null || !ScopeUtil.resolve(scope, "cameraEnabled", true).booleanValue()) {
                return Camera.getNoopEffect(effect);
            }
            class CameraEffect
            extends ViewerEffect {
                protected float _transition;
                protected Easing _easing;
                protected CameraConfig _camcfg;
                protected CameraConfig[] _camcfgs;
                protected boolean _activated;
                private final /* synthetic */ TudeySceneView val$view;

                CameraEffect(TudeySceneView tudeySceneView) {
                    this.val$view = tudeySceneView;
                    this._transition = Camera.this.transition;
                    this._easing = Camera.this.easing;
                    this._camcfg = Camera.this.camera;
                    this._camcfgs = Camera.this.cameras;
                }

                public void setConfig(Camera camera) {
                    CameraConfig cc;
                    int n;
                    int n2;
                    CameraConfig[] cameraConfigArray;
                    if (this._activated) {
                        this.val$view.removeCameraConfig(this._camcfg, 0.0f, null);
                        cameraConfigArray = this._camcfgs;
                        n2 = this._camcfgs.length;
                        n = 0;
                        while (n < n2) {
                            cc = cameraConfigArray[n];
                            this.val$view.removeCameraConfig(cc, 0.0f, null);
                            ++n;
                        }
                    }
                    this._transition = camera.transition;
                    this._easing = camera.easing;
                    this._camcfg = camera.camera;
                    this._camcfgs = camera.cameras;
                    if (this._activated) {
                        this.val$view.addCameraConfig(this._camcfg, 0.0f, null);
                        cameraConfigArray = this._camcfgs;
                        n2 = this._camcfgs.length;
                        n = 0;
                        while (n < n2) {
                            cc = cameraConfigArray[n];
                            this.val$view.addCameraConfig(cc, 0.0f, null);
                            ++n;
                        }
                    }
                }

                @Override
                public void activate(Scene scene) {
                    this._activated = true;
                    this.val$view.addCameraConfig(this._camcfg, this._transition, this._easing);
                    CameraConfig[] cameraConfigArray = this._camcfgs;
                    int n = this._camcfgs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CameraConfig cc = cameraConfigArray[n2];
                        this.val$view.addCameraConfig(cc, 0.0f, null);
                        ++n2;
                    }
                }

                @Override
                public void deactivate() {
                    this.val$view.removeCameraConfig(this._camcfg, this._transition, this._easing);
                    CameraConfig[] cameraConfigArray = this._camcfgs;
                    int n = this._camcfgs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CameraConfig cc = cameraConfigArray[n2];
                        this.val$view.removeCameraConfig(cc, 0.0f, null);
                        ++n2;
                    }
                    this._activated = false;
                }
            }
            if (effect instanceof CameraEffect) {
                ((CameraEffect)effect).setConfig(this);
            } else {
                effect = new CameraEffect(view);
            }
            return effect;
        }
    }
}

